/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.core.filterchain;

import java.util.concurrent.Executor;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.mina.core.filterchain.AssertAlignedFilter;
import org.kaazing.mina.core.filterchain.DefaultIoFilterChain;
import org.kaazing.mina.core.session.AbstractIoSessionEx;

public class DefaultIoFilterChainEx
extends DefaultIoFilterChain {
    private final Thread ioThread;
    private final Executor ioExecutor;

    public DefaultIoFilterChainEx(DefaultIoFilterChainEx filterChain, Thread ioThread, Executor ioExecutor) {
        super(filterChain);
        this.ioThread = ioThread;
        this.ioExecutor = ioExecutor;
    }

    public DefaultIoFilterChainEx(AbstractIoSessionEx session) {
        super(session);
        this.ioThread = session.getIoThread();
        this.ioExecutor = session.getIoExecutor();
        if (AssertAlignedFilter.isAssertEnabled()) {
            this.addFirst("assert thread aligned", new AssertAlignedFilter(session));
        }
    }

    @Override
    protected final void callNextSessionCreated(final IoFilterChain.Entry entry, final IoSession session) {
        if (this.aligned()) {
            super.callNextSessionCreated(entry, session);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultIoFilterChainEx.this.callNextSessionCreated(entry, session);
                }
            });
        }
    }

    @Override
    protected final void callNextSessionOpened(final IoFilterChain.Entry entry, final IoSession session) {
        if (this.aligned()) {
            super.callNextSessionOpened(entry, session);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultIoFilterChainEx.this.callNextSessionOpened(entry, session);
                }
            });
        }
    }

    @Override
    protected final void callNextSessionClosed(final IoFilterChain.Entry entry, final IoSession session) {
        if (this.aligned()) {
            super.callNextSessionClosed(entry, session);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultIoFilterChainEx.this.callNextSessionClosed(entry, session);
                }
            });
        }
    }

    @Override
    protected final void callNextSessionIdle(IoFilterChain.Entry entry, IoSession session, IdleStatus status) {
        if (this.aligned()) {
            super.callNextSessionIdle(entry, session, status);
        } else {
            this.execute(new CallNextSessionIdleCommand(status, entry, session));
        }
    }

    @Override
    protected final void callNextMessageReceived(final IoFilterChain.Entry entry, final IoSession session, final Object message) {
        if (this.aligned()) {
            super.callNextMessageReceived(entry, session, message);
        } else {
            session.suspendRead();
            this.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultIoFilterChainEx.this.callNextMessageReceived(entry, session, message);
                    session.resumeRead();
                }
            });
        }
    }

    @Override
    protected final void callNextMessageSent(final IoFilterChain.Entry entry, final IoSession session, final WriteRequest writeRequest) {
        if (this.aligned()) {
            super.callNextMessageSent(entry, session, writeRequest);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultIoFilterChainEx.this.callNextMessageSent(entry, session, writeRequest);
                }
            });
        }
    }

    @Override
    protected final void callNextExceptionCaught(final IoFilterChain.Entry entry, final IoSession session, final Throwable cause) {
        if (this.aligned()) {
            super.callNextExceptionCaught(entry, session, cause);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultIoFilterChainEx.this.callNextExceptionCaught(entry, session, cause);
                }
            });
        }
    }

    @Override
    protected final void callPreviousFilterWrite(IoFilterChain.Entry entry, final IoSession session, final WriteRequest writeRequest) {
        if (this.aligned()) {
            super.callPreviousFilterWrite(entry, session, writeRequest);
        } else {
            final IoFilterChain.Entry entry0 = entry;
            this.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultIoFilterChainEx.this.callPreviousFilterWrite(entry0, session, writeRequest);
                }
            });
        }
    }

    @Override
    protected final void callPreviousFilterClose(final IoFilterChain.Entry entry, final IoSession session) {
        if (this.aligned()) {
            super.callPreviousFilterClose(entry, session);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultIoFilterChainEx.this.callPreviousFilterClose(entry, session);
                }
            });
        }
    }

    private boolean aligned() {
        return Thread.currentThread() == this.ioThread;
    }

    private void execute(Runnable command) {
        this.ioExecutor.execute(command);
    }

    public final class CallNextSessionIdleCommand
    implements Runnable {
        private final IdleStatus status;
        private final IoFilterChain.Entry entry;
        private final IoSession session;

        public CallNextSessionIdleCommand(IdleStatus status, IoFilterChain.Entry entry, IoSession session) {
            this.status = status;
            this.entry = entry;
            this.session = session;
        }

        @Override
        public void run() {
            DefaultIoFilterChainEx.this.callNextSessionIdle(this.entry, this.session, this.status);
        }
    }
}

