/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.filter.codec;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.buffer.SimpleBufferAllocator;

public abstract class AbstractProtocolEncoderOutputEx
implements ProtocolEncoderOutput {
    private final Queue<Object> messageQueue = new ConcurrentLinkedQueue<Object>();
    private boolean buffersOnly = true;

    public Queue<Object> getMessageQueue() {
        return this.messageQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Object encodedMessage) {
        if (encodedMessage instanceof IoBufferEx) {
            IoBufferEx buf = (IoBufferEx)encodedMessage;
            if (!buf.hasRemaining()) throw new IllegalArgumentException("buf is empty. Forgot to call flip()?");
            this.messageQueue.offer(buf);
            return;
        } else {
            this.messageQueue.offer(encodedMessage);
            this.buffersOnly = false;
        }
    }

    @Override
    public void mergeAll() {
        IoBufferEx ioBufferEx;
        if (!this.buffersOnly) {
            throw new IllegalStateException("the encoded message list contains a non-buffer.");
        }
        int size = this.messageQueue.size();
        if (size < 2) {
            return;
        }
        int sum = 0;
        for (Object e : this.messageQueue) {
            sum += ((IoBufferEx)e).remaining();
        }
        IoBufferEx newBuf = SimpleBufferAllocator.BUFFER_ALLOCATOR.wrap(ByteBuffer.allocate(sum));
        while ((ioBufferEx = (IoBufferEx)this.messageQueue.poll()) != null) {
            newBuf.put(ioBufferEx);
        }
        newBuf.flip();
        this.messageQueue.add(newBuf);
    }
}

