/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.jboss.netty.channel.socket.nio.AbstractNioChannel;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.NioChildDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.channel.socket.nio.SelectorUtil;
import org.jboss.netty.channel.socket.nio.SocketSendBufferPool;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.kaazing.mina.netty.config.InternalSystemProperty;

public class NioWorker
extends AbstractNioWorker {
    private final long MAXIMUM_PROCESS_TASKS_TIME_MILLIS = InternalSystemProperty.MAXIMUM_PROCESS_TASKS_TIME.getLongProperty(System.getProperties());
    private final long MAXIMUM_PROCESS_TASKS_TIME_NANOS = TimeUnit.MILLISECONDS.toNanos(this.MAXIMUM_PROCESS_TASKS_TIME_MILLIS);
    private final long QUICK_SELECT_TIMEOUT = InternalSystemProperty.QUICK_SELECT_TIMEOUT.getLongProperty(System.getProperties());

    public NioWorker(Executor executor) {
        super(executor);
        if (this.MAXIMUM_PROCESS_TASKS_TIME_MILLIS > 0L) {
            String message = String.format("NioWorker: maximum task queue processing time = %d ms. Quick select timeout = %s.", this.MAXIMUM_PROCESS_TASKS_TIME_MILLIS, this.QUICK_SELECT_TIMEOUT == 0L ? "selectNow used" : Long.valueOf(this.QUICK_SELECT_TIMEOUT));
            if (PERF_LOGGER.isInfoEnabled()) {
                PERF_LOGGER.info(message);
            } else {
                System.out.println(message);
            }
        }
    }

    public NioWorker(Executor executor, ThreadNameDeterminer determiner) {
        super(executor, determiner);
        if (this.MAXIMUM_PROCESS_TASKS_TIME_MILLIS > 0L) {
            String message = String.format("NioWorker: maximum task queue processing time = %d ms. Quick select timeout = %s.", this.MAXIMUM_PROCESS_TASKS_TIME_MILLIS, this.QUICK_SELECT_TIMEOUT == 0L ? "selectNow used" : Long.valueOf(this.QUICK_SELECT_TIMEOUT));
            if (PERF_LOGGER.isInfoEnabled()) {
                PERF_LOGGER.info(message);
            } else {
                System.out.println(message);
            }
        }
    }

    @Override
    protected final long getMaximumProcessTaskQueueTimeNanos() {
        return this.MAXIMUM_PROCESS_TASKS_TIME_NANOS;
    }

    @Override
    protected boolean read(SelectionKey k) {
        ReadDispatcher dispatcher = (ReadDispatcher)k.attachment();
        return dispatcher.dispatch(this, k);
    }

    private boolean readTcp(SelectionKey k, NioSocketChannel channel) {
        SocketChannel ch = (SocketChannel)k.channel();
        ReceiveBufferSizePredictor predictor = channel.getConfig().getReceiveBufferSizePredictor();
        int predictedRecvBufSize = predictor.nextReceiveBufferSize();
        ChannelBufferFactory bufferFactory = channel.getConfig().getBufferFactory();
        int ret = 0;
        int readBytes = 0;
        boolean failure = true;
        ByteBuffer bb = this.recvBufferPool.get(predictedRecvBufSize).order(bufferFactory.getDefaultOrder());
        try {
            while ((ret = ch.read(bb)) > 0) {
                readBytes += ret;
                if (bb.hasRemaining()) continue;
            }
            failure = false;
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        if (readBytes > 0) {
            bb.flip();
            ChannelBuffer buffer = bufferFactory.getBuffer(readBytes);
            buffer.setBytes(0, bb);
            buffer.writerIndex(readBytes);
            predictor.previousReceiveBufferSize(readBytes);
            Channels.fireMessageReceived(channel, (Object)buffer);
        }
        if (ret < 0 || failure) {
            k.cancel();
            this.close(channel, Channels.succeededFuture(channel));
            return false;
        }
        return true;
    }

    @Override
    protected boolean scheduleWriteIfNecessary(AbstractNioChannel<?> channel) {
        Thread workerThread;
        Thread currentThread = Thread.currentThread();
        if (currentThread != (workerThread = this.thread)) {
            if (channel.writeTaskInTaskQueue.compareAndSet(false, true)) {
                this.registerTask(channel.writeTask);
            }
            return true;
        }
        return false;
    }

    @Override
    protected int select(Selector selector, boolean quickSelect) throws IOException {
        if (quickSelect) {
            return SelectorUtil.select(selector, this.QUICK_SELECT_TIMEOUT);
        }
        return SelectorUtil.select(selector);
    }

    @Override
    protected Runnable createRegisterTask(Channel channel, ChannelFuture future) {
        if (channel instanceof NioSocketChannel) {
            boolean server = !(channel instanceof NioClientSocketChannel);
            return new TcpChannelRegisterTask((NioSocketChannel)channel, future, server);
        }
        return new UdpChannelRegistionTask((NioDatagramChannel)channel, future);
    }

    @Override
    public void run() {
        super.run();
        this.recvBufferPool.releaseExternalResources();
    }

    @Override
    protected void write0(AbstractNioChannel<?> channel) {
        if (channel instanceof NioSocketChannel || channel instanceof NioChildDatagramChannel) {
            super.write0(channel);
        } else {
            this.write0Udp(channel);
        }
    }

    @Override
    void writeFromUserCode(AbstractNioChannel<?> channel) {
        if (channel instanceof NioDatagramChannel) {
            this.writeFromUserCodeUdp(channel);
        } else {
            super.writeFromUserCode(channel);
        }
    }

    @Override
    protected void close(SelectionKey k) {
        ReadDispatcher dispatcher = (ReadDispatcher)k.attachment();
        AbstractNioChannel ch = dispatcher.channel();
        this.close(ch, Channels.succeededFuture(ch));
    }

    @Override
    void writeFromSelectorLoop(SelectionKey k) {
        ReadDispatcher dispatcher = (ReadDispatcher)k.attachment();
        AbstractNioChannel ch = dispatcher.channel();
        ch.writeSuspended = false;
        this.write0(ch);
    }

    private boolean readUdp(SelectionKey key, NioDatagramChannel channel) {
        ReceiveBufferSizePredictor predictor = channel.getConfig().getReceiveBufferSizePredictor();
        ChannelBufferFactory bufferFactory = channel.getConfig().getBufferFactory();
        DatagramChannel nioChannel = (DatagramChannel)key.channel();
        int predictedRecvBufSize = predictor.nextReceiveBufferSize();
        ByteBuffer byteBuffer = this.recvBufferPool.get(predictedRecvBufSize).order(bufferFactory.getDefaultOrder());
        boolean failure = true;
        SocketAddress remoteAddress = null;
        try {
            remoteAddress = nioChannel.receive(byteBuffer);
            failure = false;
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        if (remoteAddress != null) {
            byteBuffer.flip();
            int readBytes = byteBuffer.remaining();
            if (readBytes > 0) {
                predictor.previousReceiveBufferSize(readBytes);
                ChannelBuffer buffer = bufferFactory.getBuffer(readBytes);
                buffer.setBytes(0, byteBuffer);
                buffer.writerIndex(readBytes);
                predictor.previousReceiveBufferSize(readBytes);
                Channels.fireMessageReceived(channel, (Object)buffer, remoteAddress);
            }
        }
        if (failure) {
            key.cancel();
            this.close(channel, Channels.succeededFuture(channel));
            return false;
        }
        return true;
    }

    void writeFromUserCodeUdp(AbstractNioChannel<?> channel) {
        assert (channel instanceof NioDatagramChannel);
        if (!channel.isBound()) {
            NioWorker.cleanUpWriteBuffer(channel);
            return;
        }
        if (this.scheduleWriteIfNecessary(channel)) {
            return;
        }
        if (channel.writeSuspended) {
            return;
        }
        if (channel.inWriteNowLoop) {
            return;
        }
        this.write0(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write0Udp(AbstractNioChannel<?> channel) {
        assert (channel instanceof NioDatagramChannel);
        boolean addOpWrite = false;
        boolean removeOpWrite = false;
        long writtenBytes = 0L;
        SocketSendBufferPool sendBufferPool = this.sendBufferPool;
        DatagramChannel ch = ((NioDatagramChannel)channel).getDatagramChannel();
        Queue<MessageEvent> writeBuffer = channel.writeBufferQueue;
        int writeSpinCount = channel.getConfig().getWriteSpinCount();
        Object object = channel.writeLock;
        synchronized (object) {
            channel.inWriteNowLoop = true;
            while (true) {
                SocketSendBufferPool.SendBuffer buf;
                MessageEvent evt;
                if ((evt = channel.currentWriteEvent) == null) {
                    channel.currentWriteEvent = evt = writeBuffer.poll();
                    if (evt == null) {
                        removeOpWrite = true;
                        channel.writeSuspended = false;
                        break;
                    }
                    channel.currentWriteBuffer = buf = sendBufferPool.acquire(channel, evt.getMessage());
                } else {
                    buf = channel.currentWriteBuffer;
                }
                try {
                    int i;
                    long localWrittenBytes = 0L;
                    SocketAddress raddr = evt.getRemoteAddress();
                    if (raddr == null) {
                        for (i = writeSpinCount; i > 0; --i) {
                            localWrittenBytes = buf.transferTo(ch);
                            if (localWrittenBytes != 0L) {
                                writtenBytes += localWrittenBytes;
                            } else if (!buf.finished()) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (i = writeSpinCount; i > 0; --i) {
                            localWrittenBytes = buf.transferTo(ch, raddr);
                            if (localWrittenBytes != 0L) {
                                writtenBytes += localWrittenBytes;
                            } else if (!buf.finished()) {
                                continue;
                            }
                            break;
                        }
                    }
                    if (localWrittenBytes > 0L || buf.finished()) {
                        buf.release();
                        ChannelFuture future = evt.getFuture();
                        channel.currentWriteEvent = null;
                        channel.currentWriteBuffer = null;
                        evt = null;
                        buf = null;
                        future.setSuccess();
                        continue;
                    }
                    addOpWrite = true;
                    channel.writeSuspended = true;
                }
                catch (AsynchronousCloseException localWrittenBytes) {
                    continue;
                }
                catch (Throwable t) {
                    buf.release();
                    ChannelFuture future = evt.getFuture();
                    channel.currentWriteEvent = null;
                    channel.currentWriteBuffer = null;
                    buf = null;
                    evt = null;
                    future.setFailure(t);
                    Channels.fireExceptionCaught(channel, t);
                    continue;
                }
                break;
            }
            channel.inWriteNowLoop = false;
            if (addOpWrite) {
                this.setOpWrite(channel);
            } else if (removeOpWrite) {
                this.clearOpWrite(channel);
            }
        }
        Channels.fireWriteComplete(channel, writtenBytes);
    }

    static final class UdpReadDispatcher
    implements ReadDispatcher {
        private final NioDatagramChannel channel;

        UdpReadDispatcher(NioDatagramChannel channel) {
            this.channel = channel;
        }

        @Override
        public AbstractNioChannel channel() {
            return this.channel;
        }

        @Override
        public boolean dispatch(NioWorker worker, SelectionKey key) {
            return worker.readUdp(key, this.channel);
        }
    }

    static final class TcpReadDispatcher
    implements ReadDispatcher {
        private final NioSocketChannel channel;

        TcpReadDispatcher(NioSocketChannel channel) {
            this.channel = channel;
        }

        @Override
        public AbstractNioChannel channel() {
            return this.channel;
        }

        @Override
        public boolean dispatch(NioWorker worker, SelectionKey key) {
            return worker.readTcp(key, this.channel);
        }
    }

    static interface ReadDispatcher {
        public AbstractNioChannel channel();

        public boolean dispatch(NioWorker var1, SelectionKey var2);
    }

    private final class UdpChannelRegistionTask
    implements Runnable {
        private final NioDatagramChannel channel;
        private final ChannelFuture future;

        UdpChannelRegistionTask(NioDatagramChannel channel, ChannelFuture future) {
            this.channel = channel;
            this.future = future;
        }

        @Override
        public void run() {
            block6: {
                InetSocketAddress localAddress = this.channel.getLocalAddress();
                InetSocketAddress remoteAddress = this.channel.getRemoteAddress();
                if (localAddress == null) {
                    if (this.future != null) {
                        this.future.setFailure(new ClosedChannelException());
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    return;
                }
                try {
                    this.channel.getDatagramChannel().register(NioWorker.this.selector, this.channel.getInternalInterestOps(), new UdpReadDispatcher(this.channel));
                    if (this.future != null) {
                        this.future.setSuccess();
                    }
                    Channels.fireChannelConnected(this.channel, (SocketAddress)remoteAddress);
                }
                catch (IOException e) {
                    if (this.future != null) {
                        this.future.setFailure(e);
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    if (e instanceof ClosedChannelException) break block6;
                    throw new ChannelException("Failed to register a socket to the selector.", e);
                }
            }
        }
    }

    private final class TcpChannelRegisterTask
    implements Runnable {
        private final NioSocketChannel channel;
        private final ChannelFuture future;
        private final boolean server;

        TcpChannelRegisterTask(NioSocketChannel channel, ChannelFuture future, boolean server) {
            this.channel = channel;
            this.future = future;
            this.server = server;
        }

        @Override
        public void run() {
            block8: {
                InetSocketAddress localAddress = this.channel.getLocalAddress();
                InetSocketAddress remoteAddress = this.channel.getRemoteAddress();
                if (localAddress == null || remoteAddress == null) {
                    if (this.future != null) {
                        this.future.setFailure(new ClosedChannelException());
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    return;
                }
                try {
                    if (this.server) {
                        ((SocketChannel)this.channel.channel).configureBlocking(false);
                    }
                    ((SocketChannel)this.channel.channel).register(NioWorker.this.selector, this.channel.getInternalInterestOps(), new TcpReadDispatcher(this.channel));
                    if (this.future != null) {
                        this.channel.setConnected();
                        this.future.setSuccess();
                    }
                    if (this.server || !((NioClientSocketChannel)this.channel).boundManually) {
                        Channels.fireChannelBound(this.channel, (SocketAddress)localAddress);
                    }
                    Channels.fireChannelConnected(this.channel, (SocketAddress)remoteAddress);
                }
                catch (IOException e) {
                    if (this.future != null) {
                        this.future.setFailure(e);
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    if (e instanceof ClosedChannelException) break block8;
                    throw new ChannelException("Failed to register a socket to the selector.", e);
                }
            }
        }
    }
}

