/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.generation;

import java.io.IOException;
import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import uk.co.real_logic.agrona.generation.JavaClassObject;

public class ClassFileManager<M extends JavaFileManager>
extends ForwardingJavaFileManager<M> {
    private final Map<String, JavaClassObject> classObjectByNameMap = new HashMap<String, JavaClassObject>();

    public ClassFileManager(M standardManager) {
        super(standardManager);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return new SecureClassLoader(){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                byte[] buffer = ((JavaClassObject)ClassFileManager.this.classObjectByNameMap.get(name)).getBytes();
                return super.defineClass(name, buffer, 0, buffer.length);
            }
        };
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavaClassObject javaClassObject = new JavaClassObject(className, kind);
        this.classObjectByNameMap.put(className, javaClassObject);
        return javaClassObject;
    }
}

