/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.util.threadlocal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class VicariousThreadLocal<T>
extends ThreadLocal<T> {
    private static final ThreadLocal<WeakReference<Thread>> weakThread = new ThreadLocal();
    private static final Object UNINITIALISED = new Object();
    private final ThreadLocal<WeakReference<Holder>> local = new ThreadLocal();
    private volatile Holder strongRefs;
    private static final AtomicReferenceFieldUpdater<VicariousThreadLocal, Holder> strongRefsUpdater = AtomicReferenceFieldUpdater.newUpdater(VicariousThreadLocal.class, Holder.class, "strongRefs");
    private final ReferenceQueue<Object> queue = new ReferenceQueue();

    static WeakReference<Thread> currentThreadRef() {
        WeakReference<Thread> ref = weakThread.get();
        if (ref == null) {
            ref = new WeakReference<Thread>(Thread.currentThread());
            weakThread.set(ref);
        }
        return ref;
    }

    public static <T> VicariousThreadLocal<T> newThreadLocal() {
        return new VicariousThreadLocal<T>();
    }

    public static <T> VicariousThreadLocal<T> newThreadLocal(final T initialValue) {
        return new VicariousThreadLocal<T>(){

            @Override
            public T initialValue() {
                return initialValue;
            }
        };
    }

    public static <T> VicariousThreadLocal<T> newThreadLocal(final Callable<T> doCall) {
        return new VicariousThreadLocal<T>(){

            @Override
            public T initialValue() {
                try {
                    return doCall.call();
                }
                catch (RuntimeException exc) {
                    throw exc;
                }
                catch (Exception exc) {
                    throw new Error(exc);
                }
            }
        };
    }

    @Override
    public T get() {
        Object value;
        Holder holder;
        WeakReference<Holder> ref = this.local.get();
        if (ref != null) {
            holder = (Holder)ref.get();
            value = holder.value;
            if (value != UNINITIALISED) {
                return value;
            }
        } else {
            holder = this.createHolder();
        }
        value = this.initialValue();
        holder.value = value;
        return value;
    }

    @Override
    public void set(T value) {
        WeakReference<Holder> ref = this.local.get();
        Holder holder = ref != null ? (Holder)ref.get() : this.createHolder();
        holder.value = value;
    }

    private Holder createHolder() {
        Holder old;
        this.poll();
        Holder holder = new Holder(this.queue);
        WeakReference<Holder> ref = new WeakReference<Holder>(holder);
        do {
            holder.next = old = this.strongRefs;
        } while (!strongRefsUpdater.compareAndSet(this, old, holder));
        this.local.set(ref);
        return holder;
    }

    @Override
    public void remove() {
        WeakReference<Holder> ref = this.local.get();
        if (ref != null) {
            ((Holder)ref.get()).value = UNINITIALISED;
        }
    }

    public boolean isInitialized() {
        WeakReference<Holder> ref = this.local.get();
        if (ref != null) {
            Holder holder = (Holder)ref.get();
            return holder != null && holder.value != UNINITIALISED;
        }
        return false;
    }

    public T swap(T value) {
        Object oldValue;
        Holder holder;
        WeakReference<Holder> ref = this.local.get();
        if (ref != null) {
            holder = (Holder)ref.get();
            Object holderValue = holder.value;
            oldValue = holderValue != UNINITIALISED ? holderValue : this.initialValue();
        } else {
            holder = this.createHolder();
            oldValue = this.initialValue();
        }
        holder.value = value;
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWith(T value, Runnable doRun) {
        WeakReference<Holder> ref = this.local.get();
        Holder holder = ref != null ? (Holder)ref.get() : this.createHolder();
        Object oldValue = holder.value;
        holder.value = value;
        try {
            doRun.run();
        }
        finally {
            holder.value = oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R callWith(T value, Callable<R> doCall) throws Exception {
        WeakReference<Holder> ref = this.local.get();
        Holder holder = ref != null ? (Holder)ref.get() : this.createHolder();
        Object oldValue = holder.value;
        holder.value = value;
        try {
            R r = doCall.call();
            return r;
        }
        finally {
            holder.value = oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() {
        ReferenceQueue<Object> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            if (this.queue.poll() == null) {
                return;
            }
            while (this.queue.poll() != null) {
            }
            Holder first = this.strongRefs;
            if (first == null) {
                return;
            }
            Holder link = first;
            Holder next = link.next;
            while (next != null) {
                if (next.get() == null) {
                    link.next = next = next.next;
                    continue;
                }
                link = next;
                next = next.next;
            }
            if (first.get() == null && !strongRefsUpdater.weakCompareAndSet(this, first, first.next)) {
                first.value = null;
            }
        }
    }

    static /* synthetic */ Object access$000() {
        return UNINITIALISED;
    }

    private static class Holder
    extends WeakReference<Object> {
        Holder next;
        Object value = VicariousThreadLocal.access$000();

        Holder(ReferenceQueue<Object> queue) {
            super(VicariousThreadLocal.currentThreadRef(), queue);
        }
    }
}

