/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.core.service;

import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.mina.core.future.IoFutureListener;
import org.kaazing.mina.core.future.BindFuture;
import org.kaazing.mina.core.future.UnbindFuture;
import org.kaazing.mina.core.service.AbstractIoAcceptor;
import org.kaazing.mina.core.service.IoAcceptorEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;
import org.kaazing.mina.core.write.WriteRequestEx;

public abstract class AbstractIoAcceptorEx
extends AbstractIoAcceptor
implements IoAcceptorEx {
    private final List<ThreadLocal<WriteRequestEx>> sharedWriteRequests = DefaultWriteRequestEx.ShareableWriteRequest.initWithLayers(16);

    protected AbstractIoAcceptorEx(IoSessionConfigEx sessionConfig, Executor executor) {
        super(sessionConfig, executor);
    }

    @Override
    public IoSessionConfigEx getSessionConfig() {
        return (IoSessionConfigEx)super.getSessionConfig();
    }

    @Override
    public final ThreadLocal<WriteRequestEx> getThreadLocalWriteRequest(int ioLayer) {
        return this.sharedWriteRequests.get(ioLayer);
    }

    @Override
    public BindFuture bindAsync(final SocketAddress localAddress) {
        if (this.isDisposing()) {
            throw new IllegalStateException("Already disposed.");
        }
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        this.checkAddressType(localAddress);
        if (this.getHandler() == null) {
            throw new IllegalStateException("handler is not set.");
        }
        BindFuture bound = this.bindAsyncInternal(localAddress);
        bound.addListener(new IoFutureListener<BindFuture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(BindFuture future) {
                if (future.isBound()) {
                    boolean activate = false;
                    Object object = AbstractIoAcceptorEx.this.bindLock;
                    synchronized (object) {
                        if (AbstractIoAcceptorEx.this.boundAddresses.isEmpty()) {
                            activate = true;
                        }
                        AbstractIoAcceptorEx.this.boundAddresses.add(localAddress);
                        if (activate) {
                            AbstractIoAcceptorEx.this.getListeners().fireServiceActivated();
                        }
                    }
                }
            }
        });
        return bound;
    }

    @Override
    public UnbindFuture unbindAsync(final SocketAddress localAddress) {
        UnbindFuture unbound = this.unbindAsyncInternal(localAddress);
        unbound.addListener(new IoFutureListener<UnbindFuture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(UnbindFuture future) {
                if (future.isUnbound()) {
                    boolean deactivate = false;
                    Object object = AbstractIoAcceptorEx.this.bindLock;
                    synchronized (object) {
                        if (AbstractIoAcceptorEx.this.boundAddresses.isEmpty()) {
                            return;
                        }
                        AbstractIoAcceptorEx.this.boundAddresses.remove(localAddress);
                        if (AbstractIoAcceptorEx.this.boundAddresses.isEmpty()) {
                            deactivate = true;
                        }
                        if (deactivate) {
                            AbstractIoAcceptorEx.this.getListeners().fireServiceDeactivated();
                        }
                    }
                }
            }
        });
        return unbound;
    }

    protected abstract BindFuture bindAsyncInternal(SocketAddress var1);

    protected abstract UnbindFuture unbindAsyncInternal(SocketAddress var1);
}

