/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent.broadcast;

import java.util.concurrent.atomic.AtomicLong;
import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.MutableDirectBuffer;
import uk.co.real_logic.agrona.UnsafeAccess;
import uk.co.real_logic.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import uk.co.real_logic.agrona.concurrent.broadcast.RecordDescriptor;

public class BroadcastReceiver {
    private long cursor = 0L;
    private long nextRecord = 0L;
    private int recordOffset = 0;
    private final int capacity;
    private final int tailIntentCounterIndex;
    private final int tailCounterIndex;
    private final int latestCounterIndex;
    private final AtomicBuffer buffer;
    private final AtomicLong lappedCount = new AtomicLong();

    public BroadcastReceiver(AtomicBuffer buffer) {
        this.buffer = buffer;
        this.capacity = buffer.capacity() - BroadcastBufferDescriptor.TRAILER_LENGTH;
        BroadcastBufferDescriptor.checkCapacity(this.capacity);
        buffer.verifyAlignment();
        this.tailIntentCounterIndex = this.capacity + BroadcastBufferDescriptor.TAIL_INTENT_COUNTER_OFFSET;
        this.tailCounterIndex = this.capacity + BroadcastBufferDescriptor.TAIL_COUNTER_OFFSET;
        this.latestCounterIndex = this.capacity + BroadcastBufferDescriptor.LATEST_COUNTER_OFFSET;
    }

    public int capacity() {
        return this.capacity;
    }

    public long lappedCount() {
        return this.lappedCount.get();
    }

    public int typeId() {
        return this.buffer.getInt(RecordDescriptor.typeOffset(this.recordOffset));
    }

    public int offset() {
        return RecordDescriptor.msgOffset(this.recordOffset);
    }

    public int length() {
        return this.buffer.getInt(RecordDescriptor.lengthOffset(this.recordOffset)) - 8;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public boolean receiveNext() {
        long cursor;
        boolean isAvailable = false;
        AtomicBuffer buffer = this.buffer;
        long tail = buffer.getLongVolatile(this.tailCounterIndex);
        if (tail > (cursor = this.nextRecord)) {
            int recordOffset = (int)cursor & this.capacity - 1;
            if (!this.validate(cursor)) {
                this.lappedCount.lazySet(this.lappedCount.get() + 1L);
                cursor = buffer.getLong(this.latestCounterIndex);
                recordOffset = (int)cursor & this.capacity - 1;
            }
            this.cursor = cursor;
            this.nextRecord = cursor + (long)BitUtil.align(buffer.getInt(RecordDescriptor.lengthOffset(recordOffset)), 8);
            if (-1 == buffer.getInt(RecordDescriptor.typeOffset(recordOffset))) {
                recordOffset = 0;
                this.cursor = this.nextRecord;
                this.nextRecord += (long)BitUtil.align(buffer.getInt(RecordDescriptor.lengthOffset(recordOffset)), 8);
            }
            this.recordOffset = recordOffset;
            isAvailable = true;
        }
        return isAvailable;
    }

    public boolean validate() {
        UnsafeAccess.UNSAFE.loadFence();
        return this.validate(this.cursor);
    }

    private boolean validate(long cursor) {
        return cursor + (long)this.capacity > this.buffer.getLongVolatile(this.tailIntentCounterIndex);
    }
}

