/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent;

import java.util.Collection;
import java.util.function.Consumer;
import uk.co.real_logic.agrona.UnsafeAccess;
import uk.co.real_logic.agrona.concurrent.AbstractConcurrentArrayQueue;

public class ManyToManyConcurrentArrayQueue<E>
extends AbstractConcurrentArrayQueue<E> {
    private static final int SEQUENCES_ARRAY_BASE;
    private final long[] sequences;

    public ManyToManyConcurrentArrayQueue(int requestedCapacity) {
        super(requestedCapacity);
        if (requestedCapacity < 2) {
            throw new IllegalArgumentException("requestCapacity must be >= 2: requestedCapacity=" + requestedCapacity);
        }
        long[] sequences = new long[this.capacity];
        int size = this.capacity;
        for (int i = 0; i < size; ++i) {
            long sequenceOffset = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(i, this.capacity - 1);
            UnsafeAccess.UNSAFE.putOrderedLong(sequences, sequenceOffset, i);
        }
        this.sequences = sequences;
    }

    @Override
    public boolean offer(E e) {
        long sequenceOffset;
        long currentTail;
        if (null == e) {
            throw new NullPointerException("element cannot be null");
        }
        long mask = this.capacity - 1;
        long[] sequences = this.sequences;
        do {
            long sequence;
            if ((sequence = UnsafeAccess.UNSAFE.getLongVolatile(sequences, sequenceOffset = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(currentTail = this.tail, mask))) >= currentTail) continue;
            return false;
        } while (!UnsafeAccess.UNSAFE.compareAndSwapLong(this, TAIL_OFFSET, currentTail, currentTail + 1L));
        UnsafeAccess.UNSAFE.putObject(this.buffer, ManyToManyConcurrentArrayQueue.sequenceToBufferOffset(currentTail, mask), e);
        UnsafeAccess.UNSAFE.putOrderedLong(sequences, sequenceOffset, currentTail + 1L);
        return true;
    }

    @Override
    public E poll() {
        long sequenceOffset;
        long attemptedHead;
        long currentHead;
        long[] sequences = this.sequences;
        long mask = this.capacity - 1;
        do {
            long sequence;
            if ((sequence = UnsafeAccess.UNSAFE.getLongVolatile(sequences, sequenceOffset = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(currentHead = this.head, mask))) >= (attemptedHead = currentHead + 1L)) continue;
            return null;
        } while (!UnsafeAccess.UNSAFE.compareAndSwapLong(this, HEAD_OFFSET, currentHead, attemptedHead));
        long elementOffset = ManyToManyConcurrentArrayQueue.sequenceToBufferOffset(currentHead, mask);
        Object e = UnsafeAccess.UNSAFE.getObject(this.buffer, elementOffset);
        UnsafeAccess.UNSAFE.putObject(this.buffer, elementOffset, null);
        UnsafeAccess.UNSAFE.putOrderedLong(sequences, sequenceOffset, attemptedHead + mask);
        return (E)e;
    }

    @Override
    public int drain(Consumer<E> elementHandler) {
        E e;
        int count;
        int size = this.size();
        for (count = 0; count < size && null != (e = this.poll()); ++count) {
            elementHandler.accept(e);
        }
        return count;
    }

    @Override
    public int drainTo(Collection<? super E> target, int limit) {
        E e;
        int count;
        for (count = 0; count < limit && null != (e = this.poll()); ++count) {
            target.add(e);
        }
        return count;
    }

    private static long sequenceArrayOffset(long sequence, long mask) {
        return (long)SEQUENCES_ARRAY_BASE + ((sequence & mask) << 3);
    }

    static {
        try {
            SEQUENCES_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

