/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.bootstrap;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ServerChannelFactory;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.NioChildDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioServerDatagramChannelFactory;
import org.kaazing.mina.netty.IoAcceptorChannelHandler;
import org.kaazing.mina.netty.bootstrap.ConnectionlessBootstrap;
import org.kaazing.mina.netty.bootstrap.ServerBootstrap;

class ConnectionlessServerBootstrap
extends ConnectionlessBootstrap
implements ServerBootstrap {
    private ChannelHandler parentHandler;

    ConnectionlessServerBootstrap() {
    }

    @Override
    public void setFactory(ChannelFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (!(factory instanceof ServerChannelFactory)) {
            final ChannelFactory factory0 = factory;
            factory = new ChannelFactory(){

                @Override
                public Channel newChannel(ChannelPipeline pipeline) {
                    return factory0.newChannel(Channels.pipeline(new ConnectionlessParentChannelHandler()));
                }

                @Override
                public void shutdown() {
                    factory0.shutdown();
                }

                @Override
                public void releaseExternalResources() {
                    factory0.releaseExternalResources();
                }
            };
        }
        super.setFactory(factory);
    }

    @Override
    public void setParentHandler(ChannelHandler parentHandler) {
        this.parentHandler = parentHandler;
    }

    @Override
    public ChannelHandler getParentHandler() {
        return this.parentHandler;
    }

    private final class ConnectionlessParentChannelHandler
    extends SimpleChannelUpstreamHandler {
        private final Map<SocketAddress, NioChildDatagramChannel> childChannels = new ConcurrentHashMap<SocketAddress, NioChildDatagramChannel>();

        ConnectionlessParentChannelHandler() {
        }

        @Override
        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.channelConnected(ctx, e);
        }

        @Override
        public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
            ((IoAcceptorChannelHandler)ConnectionlessServerBootstrap.this.parentHandler).childChannelOpen(ctx, e);
            NioChildDatagramChannel childChannel = (NioChildDatagramChannel)e.getChildChannel();
            childChannel.getWorker().executeInIoThread(() -> Channels.fireChannelConnected(childChannel, (SocketAddress)childChannel.getRemoteAddress()));
        }

        @Override
        public void childChannelClosed(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
            NioChildDatagramChannel childChannel = (NioChildDatagramChannel)e.getChildChannel();
            this.childChannels.remove(childChannel.getRemoteAddress());
            childChannel.getWorker().deregister(childChannel);
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Channel channel = e.getChannel();
            NioChildDatagramChannel childChannel = this.getChildChannel(channel, e.getRemoteAddress());
            AbstractNioWorker childWorker = childChannel.getWorker();
            childWorker.messageReceived(childChannel, e.getMessage());
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            ctx.sendUpstream(e);
        }

        @Override
        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            this.childChannels.forEach((socketAddress, childChannel) -> childChannel.close());
            this.childChannels.clear();
            e.getFuture().setSuccess();
        }

        private NioChildDatagramChannel getChildChannel(Channel channel, SocketAddress remoteAddress) throws Exception {
            return this.childChannels.computeIfAbsent(remoteAddress, x -> {
                ChannelPipeline childPipeline;
                ChannelPipelineFactory childPipelineFactory = ConnectionlessServerBootstrap.this.getPipelineFactory();
                try {
                    childPipeline = childPipelineFactory.getPipeline();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                ChannelFactory channelFactory = channel.getFactory();
                NioChildDatagramChannel childChannel = ((NioServerDatagramChannelFactory)channelFactory).newChildChannel(channel, childPipeline);
                childChannel.setLocalAddress((InetSocketAddress)channel.getLocalAddress());
                childChannel.setRemoteAddress((InetSocketAddress)remoteAddress);
                Channels.fireChannelOpen(childChannel);
                childChannel.getWorker().register(childChannel);
                return childChannel;
            });
        }
    }
}

