/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.InternetProtocolFamily;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramPipelineSink;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ExternalResourceReleasable;

public class NioClientDatagramChannelFactory
implements DatagramChannelFactory {
    private final NioDatagramPipelineSink sink;
    private final WorkerPool<NioWorker> workerPool;
    private final InternetProtocolFamily family;
    private boolean releasePool;

    public NioClientDatagramChannelFactory(WorkerPool<NioWorker> workerPool) {
        this.workerPool = workerPool;
        this.family = null;
        this.sink = new NioDatagramPipelineSink();
        this.releasePool = true;
    }

    @Override
    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return new NioDatagramChannel(this, pipeline, this.sink, this.workerPool.nextWorker(), this.family);
    }

    @Override
    public void shutdown() {
        this.workerPool.shutdown();
        if (this.releasePool) {
            this.releasePool();
        }
    }

    @Override
    public void releaseExternalResources() {
        this.workerPool.shutdown();
        this.releasePool();
    }

    private void releasePool() {
        if (this.workerPool instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)this.workerPool)).releaseExternalResources();
        }
    }
}

