/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.config;

import java.util.Properties;

public enum InternalSystemProperty {
    MAXIMUM_PROCESS_TASKS_TIME("org.kaazing.netty.MAXIMUM_PROCESS_TASKS_TIME", "0"),
    QUICK_SELECT_TIMEOUT("org.kaazing.netty.QUICK_SELECT_TIMEOUT", "0");

    private final String name;
    private final String defaultValue;

    private InternalSystemProperty(String propertyName) {
        this(propertyName, null);
    }

    private InternalSystemProperty(String name, String defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public String getProperty(Properties configuration) {
        return configuration.getProperty(this.name, this.defaultValue);
    }

    public Integer getIntProperty(Properties configuration) {
        String value = this.getProperty(configuration);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public Long getLongProperty(Properties configuration) {
        String value = this.getProperty(configuration);
        if (value == null) {
            return null;
        }
        return Long.parseLong(value);
    }

    public String getPropertyName() {
        return this.name;
    }

    public boolean isSet(Properties configuration) {
        return configuration.containsKey(this.name);
    }
}

