/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.collections;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayUtil {
    public static final int UNKNOWN_INDEX = -1;

    public static <T> T[] add(T[] oldElements, T elementToAdd) {
        int length = oldElements.length;
        T[] newElements = Arrays.copyOf(oldElements, length + 1);
        newElements[length] = elementToAdd;
        return newElements;
    }

    public static <T> T[] remove(T[] oldElements, T elementToRemove) {
        int length = oldElements.length;
        int index = -1;
        for (int i = 0; i < length; ++i) {
            if (oldElements[i] != elementToRemove) continue;
            index = i;
        }
        return ArrayUtil.remove(oldElements, index);
    }

    public static <T> T[] remove(T[] oldElements, int index) {
        if (index == -1) {
            return oldElements;
        }
        int oldLength = oldElements.length;
        int newLength = oldLength - 1;
        T[] newElements = ArrayUtil.newArray(oldElements, newLength);
        int j = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (index == i) continue;
            newElements[j++] = oldElements[i];
        }
        return newElements;
    }

    public static <T> T[] newArray(T[] oldElements, int length) {
        return (Object[])Array.newInstance(oldElements.getClass().getComponentType(), length);
    }
}

