/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.core.util;

import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util
extends IoFilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);

    public static void verifyInIoThread(IoSession session, Thread ioThread) {
        Thread current = Thread.currentThread();
        if (current != ioThread) {
            String error = String.format("expected current thread %s to match %s in session %s", current, ioThread, session);
            RuntimeException e = new RuntimeException(error);
            StackTraceElement[] stackTrace = e.getStackTrace();
            String caller = stackTrace[1].toString().replace(Util.class.getName(), Util.class.getSimpleName());
            error = String.format("%s: %s", caller, error);
            LOGGER.error(error, (Throwable)e);
            throw e;
        }
    }
}

