/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.core.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.kaazing.mina.core.buffer.AbstractIoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.AbstractIoBufferEx;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;

public final class SimpleBufferAllocator
extends AbstractIoBufferAllocatorEx<SimpleBuffer> {
    public static final SimpleBufferAllocator BUFFER_ALLOCATOR = new SimpleBufferAllocator();

    private SimpleBufferAllocator() {
    }

    @Override
    public ByteBuffer allocate(int capacity, int flags) {
        return this.allocateNioBuffer0(capacity, flags);
    }

    @Override
    public SimpleBuffer wrap(ByteBuffer nioBuffer, int flags) {
        boolean shared = (flags & 2) != 0;
        return shared ? new SimpleSharedBuffer(nioBuffer) : new SimpleUnsharedBuffer(nioBuffer);
    }

    static final class SimpleSharedBuffer
    extends SimpleBuffer {
        private final ThreadLocal<ByteBuffer> bufRef;

        protected SimpleSharedBuffer(final ByteBuffer buf) {
            super(buf.capacity());
            this.bufRef = new VicariousThreadLocal<ByteBuffer>(){

                @Override
                protected ByteBuffer initialValue() {
                    return buf.duplicate();
                }
            };
            buf.order(ByteOrder.BIG_ENDIAN);
        }

        protected SimpleSharedBuffer(SimpleBuffer parent, final ByteBuffer buf) {
            super(parent);
            this.bufRef = new VicariousThreadLocal<ByteBuffer>(){

                @Override
                protected ByteBuffer initialValue() {
                    return buf.duplicate();
                }
            };
        }

        private SimpleSharedBuffer(SimpleSharedBuffer parent, ThreadLocal<ByteBuffer> bufRef) {
            super(parent);
            this.bufRef = bufRef;
        }

        @Override
        public int flags() {
            return 2;
        }

        @Override
        protected SimpleSharedBuffer asSharedBuffer0() {
            return this;
        }

        @Override
        protected SimpleUnsharedBuffer asUnsharedBuffer0() {
            return new SimpleUnsharedBuffer(this.buf().duplicate());
        }

        @Override
        public ByteBuffer buf() {
            return this.bufRef.get();
        }

        @Override
        protected void buf(ByteBuffer buf) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected SimpleSharedBuffer duplicate0() {
            return new SimpleSharedBuffer((SimpleBuffer)this, this.buf().duplicate());
        }

        @Override
        protected SimpleSharedBuffer slice0() {
            return new SimpleSharedBuffer((SimpleBuffer)this, this.buf().slice());
        }

        @Override
        protected SimpleSharedBuffer asReadOnlyBuffer0() {
            return new SimpleSharedBuffer((SimpleBuffer)this, this.buf().asReadOnlyBuffer());
        }

        @Override
        public byte[] array() {
            return this.buf().array();
        }

        @Override
        public int arrayOffset() {
            return this.buf().arrayOffset();
        }

        @Override
        public boolean hasArray() {
            return this.buf().hasArray();
        }

        @Override
        public void free() {
        }
    }

    static final class SimpleUnsharedBuffer
    extends SimpleBuffer {
        private ByteBuffer buf;

        protected SimpleUnsharedBuffer(ByteBuffer buf) {
            super(buf.capacity());
            this.buf = buf;
            buf.order(ByteOrder.BIG_ENDIAN);
        }

        protected SimpleUnsharedBuffer(SimpleBuffer parent, ByteBuffer buf) {
            super(parent);
            this.buf = buf;
        }

        @Override
        public int flags() {
            return 0;
        }

        @Override
        protected SimpleSharedBuffer asSharedBuffer0() {
            return new SimpleSharedBuffer(this.buf);
        }

        @Override
        protected SimpleUnsharedBuffer asUnsharedBuffer0() {
            return this;
        }

        @Override
        public ByteBuffer buf() {
            return this.buf;
        }

        @Override
        protected void buf(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        protected SimpleUnsharedBuffer duplicate0() {
            return new SimpleUnsharedBuffer(this, this.buf.duplicate());
        }

        @Override
        protected SimpleUnsharedBuffer slice0() {
            return new SimpleUnsharedBuffer(this, this.buf.slice());
        }

        @Override
        protected SimpleUnsharedBuffer asReadOnlyBuffer0() {
            return new SimpleUnsharedBuffer(this, this.buf.asReadOnlyBuffer());
        }

        @Override
        public byte[] array() {
            return this.buf.array();
        }

        @Override
        public int arrayOffset() {
            return this.buf.arrayOffset();
        }

        @Override
        public boolean hasArray() {
            return this.buf.hasArray();
        }

        @Override
        public void free() {
        }
    }

    public static abstract class SimpleBuffer
    extends AbstractIoBufferEx {
        protected SimpleBuffer(int capacity) {
            super(capacity);
        }

        protected SimpleBuffer(SimpleBuffer parent) {
            super(parent);
        }
    }
}

