/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.Worker;
import org.jboss.netty.channel.socket.nio.AbstractNioChannel;
import org.jboss.netty.channel.socket.nio.AbstractNioSelector;
import org.jboss.netty.channel.socket.nio.NioChildDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.SocketReceiveBufferAllocator;
import org.jboss.netty.channel.socket.nio.SocketSendBufferPool;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.kaazing.mina.netty.channel.DefaultWriteCompletionEventEx;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.collections.Int2ObjectHashMap;
import uk.co.real_logic.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.agrona.concurrent.BackoffIdleStrategy;
import uk.co.real_logic.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.agrona.concurrent.ringbuffer.OneToOneRingBuffer;
import uk.co.real_logic.agrona.concurrent.ringbuffer.RingBufferDescriptor;

public abstract class AbstractNioWorker
extends AbstractNioSelector
implements Worker {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(AbstractNioWorker.class);
    protected final SocketReceiveBufferAllocator recvBufferPool = new SocketReceiveBufferAllocator();
    protected final SocketSendBufferPool sendBufferPool = new SocketSendBufferPool();
    private final DefaultWriteCompletionEventEx writeCompletionEvent = new DefaultWriteCompletionEventEx();
    private final OneToOneRingBuffer ringBuffer;
    private final Int2ObjectHashMap<Channel> channels;
    private final AtomicBuffer atomicBuffer = new UnsafeBuffer(new byte[0]);
    private final IdleStrategy idleStrategy = new BackoffIdleStrategy(50L, 50L, 10000L, 20000L);

    AbstractNioWorker(Executor executor) {
        this(executor, null);
    }

    AbstractNioWorker(Executor executor, ThreadNameDeterminer determiner) {
        super(executor, determiner);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384 + RingBufferDescriptor.TRAILER_LENGTH);
        this.ringBuffer = new OneToOneRingBuffer(new UnsafeBuffer(byteBuffer));
        this.channels = new Int2ObjectHashMap();
    }

    @Override
    public void executeInIoThread(Runnable task) {
        this.executeInIoThread(task, false);
    }

    public void executeInIoThread(Runnable task, boolean alwaysAsync) {
        if (!alwaysAsync && this.isIoThread()) {
            task.run();
        } else {
            this.registerTask(task);
        }
    }

    @Override
    protected void close(SelectionKey k) {
        AbstractNioChannel ch = (AbstractNioChannel)k.attachment();
        this.close(ch, Channels.succeededFuture(ch));
    }

    @Override
    protected ThreadRenamingRunnable newThreadRenamingRunnable(int id, ThreadNameDeterminer determiner) {
        return new ThreadRenamingRunnable(this, "New I/O worker #" + id, determiner);
    }

    @Override
    public void run() {
        super.run();
        this.sendBufferPool.releaseExternalResources();
        this.recvBufferPool.releaseExternalResources();
    }

    @Override
    protected void process(Selector selector) throws IOException {
        long totalTime;
        Set<SelectionKey> selectedKeys = selector.selectedKeys();
        if (selectedKeys.isEmpty()) {
            return;
        }
        boolean perfLogEnabled = PERF_LOGGER.isDebugEnabled();
        long startProcess = perfLogEnabled ? System.nanoTime() : 0L;
        long numReads = 0L;
        long numWrites = 0L;
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            try {
                int readyOps = k.readyOps();
                if ((readyOps & 1) != 0 || readyOps == 0) {
                    ++numReads;
                    if (!this.read(k)) continue;
                }
                if ((readyOps & 4) != 0) {
                    ++numWrites;
                    this.writeFromSelectorLoop(k);
                }
            }
            catch (CancelledKeyException e) {
                this.close(k);
            }
            if (!this.cleanUpCancelledKeys()) continue;
            break;
        }
        if (perfLogEnabled && (totalTime = System.nanoTime() - startProcess) >= LATENCY_BEFORE_LOG_PROCESS_SELECT) {
            PERF_LOGGER.debug(String.format("AbstractNioWorker.process(Selector) took %d ms: %d reads, %d writes", TimeUnit.NANOSECONDS.toMillis(totalTime), numReads, numWrites));
        }
    }

    void writeFromUserCode(AbstractNioChannel<?> channel) {
        if (!channel.isConnected()) {
            AbstractNioWorker.cleanUpWriteBuffer(channel);
            return;
        }
        if (this.scheduleWriteIfNecessary(channel)) {
            return;
        }
        if (channel.writeSuspended) {
            return;
        }
        if (channel.inWriteNowLoop) {
            return;
        }
        this.write0(channel);
    }

    void writeFromTaskLoop(AbstractNioChannel<?> ch) {
        if (!ch.writeSuspended) {
            this.write0(ch);
        }
    }

    void writeFromSelectorLoop(SelectionKey k) {
        AbstractNioChannel ch = (AbstractNioChannel)k.attachment();
        ch.writeSuspended = false;
        this.write0(ch);
    }

    protected abstract boolean scheduleWriteIfNecessary(AbstractNioChannel<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write0(AbstractNioChannel<?> channel) {
        boolean open = true;
        boolean addOpWrite = false;
        boolean removeOpWrite = false;
        boolean iothread = AbstractNioWorker.isIoThread(channel);
        long writtenBytes = 0L;
        SocketSendBufferPool sendBufferPool = this.sendBufferPool;
        WritableByteChannel ch = (WritableByteChannel)channel.channel;
        Queue<MessageEvent> writeBuffer = channel.writeBufferQueue;
        int writeSpinCount = channel.getConfig().getWriteSpinCount();
        ArrayList<Throwable> causes = null;
        Iterator iterator = channel.writeLock;
        synchronized (iterator) {
            channel.inWriteNowLoop = true;
            while (true) {
                MessageEvent evt = channel.currentWriteEvent;
                SocketSendBufferPool.SendBuffer buf = null;
                ChannelFuture future = null;
                try {
                    if (evt == null) {
                        channel.currentWriteEvent = evt = writeBuffer.poll();
                        if (evt == null) {
                            removeOpWrite = true;
                            channel.writeSuspended = false;
                            break;
                        }
                        future = evt.getFuture();
                        channel.currentWriteBuffer = buf = sendBufferPool.acquire(channel, evt.getMessage());
                    } else {
                        future = evt.getFuture();
                        buf = channel.currentWriteBuffer;
                    }
                    long localWrittenBytes = 0L;
                    for (int i = writeSpinCount; i > 0; --i) {
                        localWrittenBytes = buf.transferTo(ch);
                        if (localWrittenBytes != 0L) {
                            writtenBytes += localWrittenBytes;
                            break;
                        }
                        if (buf.finished()) break;
                    }
                    if (buf.finished()) {
                        buf.release();
                        channel.currentWriteEvent = null;
                        channel.currentWriteBuffer = null;
                        evt = null;
                        buf = null;
                        future.setSuccess();
                        continue;
                    }
                    addOpWrite = true;
                    channel.writeSuspended = true;
                    if (writtenBytes <= 0L) break;
                    future.setProgress(localWrittenBytes, buf.writtenBytes(), buf.totalBytes());
                }
                catch (AsynchronousCloseException localWrittenBytes) {
                    continue;
                }
                catch (Throwable t) {
                    if (buf != null) {
                        buf.release();
                    }
                    channel.currentWriteEvent = null;
                    channel.currentWriteBuffer = null;
                    buf = null;
                    evt = null;
                    if (future != null) {
                        future.setFailure(t);
                    }
                    if (iothread) {
                        if (causes == null) {
                            causes = new ArrayList<Throwable>(1);
                        }
                        causes.add(t);
                    } else {
                        Channels.fireExceptionCaughtLater(channel, t);
                    }
                    if (!(t instanceof IOException)) continue;
                    open = false;
                    continue;
                }
                break;
            }
            channel.inWriteNowLoop = false;
            if (open) {
                if (addOpWrite) {
                    this.setOpWrite(channel);
                } else if (removeOpWrite) {
                    this.clearOpWrite(channel);
                }
            }
        }
        if (causes != null) {
            for (Throwable cause : causes) {
                Channels.fireExceptionCaught(channel, cause);
            }
        }
        if (!open) {
            this.close(channel, Channels.succeededFuture(channel));
        }
        if (iothread) {
            if (writtenBytes > 0L) {
                this.writeCompletionEvent.init(channel, writtenBytes);
                channel.getPipeline().sendUpstream(this.writeCompletionEvent);
            }
        } else {
            Channels.fireWriteCompleteLater(channel, writtenBytes);
        }
    }

    static boolean isIoThread(AbstractNioChannel<?> channel) {
        AbstractNioWorker worker = channel.worker;
        return worker != null && Thread.currentThread() == worker.thread;
    }

    protected void setOpWrite(AbstractNioChannel<?> channel) {
        Selector selector = this.selector;
        SelectionKey key = ((SelectableChannel)channel.channel).keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            this.close(key);
            return;
        }
        int interestOps = channel.getRawInterestOps();
        if ((interestOps & 4) == 0) {
            key.interestOps(interestOps |= 4);
            channel.setRawInterestOpsNow(interestOps);
        }
    }

    protected void clearOpWrite(AbstractNioChannel<?> channel) {
        Selector selector = this.selector;
        SelectionKey key = ((SelectableChannel)channel.channel).keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            this.close(key);
            return;
        }
        int interestOps = channel.getRawInterestOps();
        if ((interestOps & 4) != 0) {
            key.interestOps(interestOps &= 0xFFFFFFFB);
            channel.setRawInterestOpsNow(interestOps);
        }
    }

    protected void close(AbstractNioChannel<?> channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        boolean iothread = AbstractNioWorker.isIoThread(channel);
        try {
            ((AbstractInterruptibleChannel)channel.channel).close();
            this.increaseCancelledKeys();
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    if (iothread) {
                        Channels.fireChannelDisconnected(channel);
                    } else {
                        Channels.fireChannelDisconnectedLater(channel);
                    }
                }
                if (bound) {
                    if (iothread) {
                        Channels.fireChannelUnbound(channel);
                    } else {
                        Channels.fireChannelUnboundLater(channel);
                    }
                }
                AbstractNioWorker.cleanUpWriteBuffer(channel);
                if (iothread) {
                    Channels.fireChannelClosed(channel);
                } else {
                    Channels.fireChannelClosedLater(channel);
                }
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            if (iothread) {
                Channels.fireExceptionCaught(channel, t);
            }
            Channels.fireExceptionCaughtLater(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cleanUpWriteBuffer(AbstractNioChannel<?> channel) {
        Exception cause = null;
        boolean fireExceptionCaught = false;
        Object object = channel.writeLock;
        synchronized (object) {
            MessageEvent evt = channel.currentWriteEvent;
            if (evt != null) {
                cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                ChannelFuture future = evt.getFuture();
                if (channel.currentWriteBuffer != null) {
                    channel.currentWriteBuffer.release();
                    channel.currentWriteBuffer = null;
                }
                channel.currentWriteEvent = null;
                evt = null;
                future.setFailure(cause);
                fireExceptionCaught = true;
            }
            Queue<MessageEvent> writeBuffer = channel.writeBufferQueue;
            while ((evt = writeBuffer.poll()) != null) {
                if (cause == null) {
                    cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                    fireExceptionCaught = true;
                }
                evt.getFuture().setFailure(cause);
            }
        }
        if (fireExceptionCaught) {
            if (AbstractNioWorker.isIoThread(channel)) {
                Channels.fireExceptionCaught(channel, (Throwable)cause);
            } else {
                Channels.fireExceptionCaughtLater(channel, (Throwable)cause);
            }
        }
    }

    void setInterestOps(final AbstractNioChannel<?> channel, final ChannelFuture future, final int interestOps) {
        boolean iothread = AbstractNioWorker.isIoThread(channel);
        if (!iothread) {
            channel.getPipeline().execute(new Runnable(){

                @Override
                public void run() {
                    AbstractNioWorker.this.setInterestOps(channel, future, interestOps);
                }
            });
            return;
        }
        boolean changed = false;
        try {
            Selector selector = this.selector;
            SelectionKey key = ((SelectableChannel)channel.channel).keyFor(selector);
            int newInterestOps = interestOps & 0xFFFFFFFB | channel.getRawInterestOps() & 4;
            if (key == null || selector == null) {
                if (channel.getRawInterestOps() != newInterestOps) {
                    changed = true;
                }
                channel.setRawInterestOpsNow(newInterestOps);
                future.setSuccess();
                if (changed) {
                    if (iothread) {
                        Channels.fireChannelInterestChanged(channel);
                    } else {
                        Channels.fireChannelInterestChangedLater(channel);
                    }
                }
                return;
            }
            if (channel.getRawInterestOps() != newInterestOps) {
                changed = true;
                key.interestOps(newInterestOps);
                if (Thread.currentThread() != this.thread && this.wakenUp.compareAndSet(false, true)) {
                    selector.wakeup();
                }
                channel.setRawInterestOpsNow(newInterestOps);
            }
            future.setSuccess();
            if (changed) {
                Channels.fireChannelInterestChanged(channel);
            }
        }
        catch (CancelledKeyException e) {
            ClosedChannelException cce = new ClosedChannelException();
            future.setFailure(cce);
            Channels.fireExceptionCaught(channel, (Throwable)cce);
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    protected abstract boolean read(SelectionKey var1);

    public void deregister(final AbstractNioChannel<?> channel) {
        this.registerTask(new Runnable(){

            @Override
            public void run() {
                AbstractNioWorker.this.channels.remove(channel.getId());
                if (channel instanceof NioChildDatagramChannel) {
                    return;
                }
                SelectionKey key = ((SelectableChannel)channel.channel).keyFor(AbstractNioWorker.this.selector);
                if (key != null) {
                    key.cancel();
                    AbstractNioWorker.this.increaseCancelledKeys();
                    try {
                        AbstractNioWorker.this.selector.selectNow();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (AbstractNioWorker.this.wakenUp.compareAndSet(false, true)) {
                        AbstractNioWorker.this.selector.wakeup();
                    }
                }
            }
        });
    }

    public void register(final AbstractNioChannel<?> channel) {
        this.registerTask(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractNioWorker.this.channels.put((int)channel.getId(), channel);
                    if (channel instanceof NioChildDatagramChannel) {
                        return;
                    }
                    int rawInterestOps = channel.getRawInterestOps();
                    channel.setRawInterestOpsNow(rawInterestOps |= 4);
                    NioWorker.ReadDispatcher readDispatcher = channel instanceof NioSocketChannel ? new NioWorker.TcpReadDispatcher((NioSocketChannel)channel) : new NioWorker.UdpReadDispatcher((NioDatagramChannel)channel);
                    ((SelectableChannel)channel.channel).register(AbstractNioWorker.this.selector, rawInterestOps, readDispatcher);
                }
                catch (ClosedChannelException e) {
                    AbstractNioWorker.this.close(channel, Channels.succeededFuture(channel));
                }
            }
        });
    }

    public void messageReceived(AbstractNioChannel<?> channel, Object message) {
        assert (channel.getId() >= 0);
        ChannelBuffer buf = (ChannelBuffer)message;
        ByteBuffer byteBuffer = buf.toByteBuffer();
        this.atomicBuffer.wrap(byteBuffer);
        boolean written = this.ringBuffer.write(channel.getId(), this.atomicBuffer, 0, this.atomicBuffer.capacity());
        if (LOGGER.isDebugEnabled() && !written) {
            LOGGER.debug(String.format("Message %s for channel %s is not written to ring buffer", message, channel));
        }
    }

    @Override
    protected void processRead() throws IOException {
        if (this.ringBuffer == null) {
            return;
        }
        int workCount = this.ringBuffer.read(this::handleRead);
        this.idleStrategy.idle(workCount);
    }

    private void handleRead(int msgTypeId, DirectBuffer buffer, int index, int length) {
        Channel childChannel = this.channels.get(msgTypeId);
        if (childChannel == null) {
            this.processTaskQueue();
            childChannel = this.channels.get(msgTypeId);
        }
        if (childChannel != null) {
            ChannelBufferFactory bufferFactory = childChannel.getConfig().getBufferFactory();
            ByteBuffer byteBuffer = this.recvBufferPool.get(length).order(bufferFactory.getDefaultOrder());
            buffer.getBytes(index, byteBuffer, length);
            byteBuffer.flip();
            ChannelBuffer channelBuffer = bufferFactory.getBuffer(byteBuffer);
            Channels.fireMessageReceived(childChannel, (Object)channelBuffer);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("There is no channel %s found, so dropping message %s", msgTypeId, buffer));
        }
    }
}

