/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.AbstractChannel;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.NioChannelConfig;
import org.jboss.netty.channel.socket.nio.SocketSendBufferPool;
import org.jboss.netty.util.internal.ThreadLocalBoolean;

abstract class AbstractNioChannel<C extends SelectableChannel>
extends AbstractChannel {
    volatile AbstractNioWorker worker;
    final Object writeLock = new Object();
    final Runnable writeTask = new WriteTask();
    final AtomicBoolean writeTaskInTaskQueue = new AtomicBoolean();
    final Queue<MessageEvent> writeBufferQueue;
    final AtomicInteger writeBufferSize = new AtomicInteger();
    final AtomicInteger highWaterMarkCounter = new AtomicInteger();
    MessageEvent currentWriteEvent;
    SocketSendBufferPool.SendBuffer currentWriteBuffer;
    SocketSendBufferPool.SendBuffer sharedUnpooled;
    SocketSendBufferPool.SendBuffer sharedPooled;
    boolean inWriteNowLoop;
    boolean writeSuspended;
    volatile InetSocketAddress localAddress;
    volatile InetSocketAddress remoteAddress;
    final C channel;

    protected AbstractNioChannel(Integer id, Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, AbstractNioWorker worker, C ch) {
        super(id, parent, factory, pipeline, sink);
        this.worker = worker;
        this.channel = ch;
        this.writeBufferQueue = new WriteRequestQueue(new ArrayDeque<MessageEvent>(16));
    }

    protected AbstractNioChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, AbstractNioWorker worker, C ch) {
        this(parent, factory, pipeline, sink, worker, ch, false);
    }

    protected AbstractNioChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, AbstractNioWorker worker, C ch, boolean concurrent) {
        super(parent, factory, pipeline, sink);
        this.worker = worker;
        this.channel = ch;
        this.writeBufferQueue = new WriteRequestQueue((Queue<MessageEvent>)((Object)(concurrent ? new ConcurrentLinkedQueue() : new ArrayDeque(16))));
    }

    public AbstractNioWorker getWorker() {
        return this.worker;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        InetSocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            try {
                localAddress = this.getLocalSocketAddress();
                if (localAddress.getAddress().isAnyLocalAddress()) {
                    return localAddress;
                }
                this.localAddress = localAddress;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return localAddress;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            try {
                this.remoteAddress = remoteAddress = this.getRemoteSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return remoteAddress;
    }

    @Override
    public abstract NioChannelConfig getConfig();

    @Override
    protected int getInternalInterestOps() {
        return super.getInternalInterestOps();
    }

    @Override
    protected void setInternalInterestOps(int interestOps) {
        super.setInternalInterestOps(interestOps);
    }

    public void setWorker(AbstractNioWorker newWorker) {
        if (newWorker == null) {
            if (this.worker == null) {
                throw new IllegalStateException("Cannot deregister more than once without re-register");
            }
            this.worker.deregister(this);
        } else {
            this.worker = newWorker;
            this.worker.register(this);
        }
    }

    int getRawInterestOps() {
        return super.getInterestOps();
    }

    void setRawInterestOpsNow(int interestOps) {
        this.setInternalInterestOps(interestOps);
    }

    @Override
    public int getInterestOps() {
        int highWaterMark;
        int lowWaterMark;
        if (!this.isOpen()) {
            return 4;
        }
        int interestOps = this.getRawInterestOps();
        int writeBufferSize = this.writeBufferSize.get();
        interestOps = writeBufferSize != 0 ? (this.highWaterMarkCounter.get() > 0 ? (writeBufferSize >= (lowWaterMark = this.getConfig().getWriteBufferLowWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB)) : (writeBufferSize >= (highWaterMark = this.getConfig().getWriteBufferHighWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB))) : (interestOps &= 0xFFFFFFFB);
        return interestOps;
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }

    abstract InetSocketAddress getLocalSocketAddress() throws Exception;

    abstract InetSocketAddress getRemoteSocketAddress() throws Exception;

    private final class WriteTask
    implements Runnable {
        WriteTask() {
        }

        @Override
        public void run() {
            AbstractNioChannel.this.writeTaskInTaskQueue.set(false);
            AbstractNioChannel.this.worker.writeFromTaskLoop(AbstractNioChannel.this);
        }
    }

    private final class WriteRequestQueue
    implements Queue<MessageEvent> {
        private final ThreadLocalBoolean notifying = new ThreadLocalBoolean();
        private final Queue<MessageEvent> queue;

        public WriteRequestQueue(Queue<MessageEvent> queue) {
            this.queue = queue;
        }

        @Override
        public MessageEvent remove() {
            return this.queue.remove();
        }

        @Override
        public MessageEvent element() {
            return this.queue.element();
        }

        @Override
        public MessageEvent peek() {
            return this.queue.peek();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public Iterator<MessageEvent> iterator() {
            return this.queue.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.queue.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.queue.toArray(a);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.queue.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends MessageEvent> c) {
            return this.queue.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.queue.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.queue.retainAll(c);
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean add(MessageEvent e) {
            return this.queue.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.queue.remove(o);
        }

        @Override
        public boolean contains(Object o) {
            return this.queue.contains(o);
        }

        @Override
        public boolean offer(MessageEvent e) {
            int highWaterMark;
            boolean success = this.queue.offer(e);
            assert (success);
            int messageSize = this.getMessageSize(e);
            int newWriteBufferSize = AbstractNioChannel.this.writeBufferSize.addAndGet(messageSize);
            if (newWriteBufferSize >= (highWaterMark = AbstractNioChannel.this.getConfig().getWriteBufferHighWaterMark()) && newWriteBufferSize - messageSize < highWaterMark) {
                AbstractNioChannel.this.highWaterMarkCounter.incrementAndGet();
                if (!((Boolean)this.notifying.get()).booleanValue()) {
                    this.notifying.set(Boolean.TRUE);
                    Channels.fireChannelInterestChanged(AbstractNioChannel.this);
                    this.notifying.set(Boolean.FALSE);
                }
            }
            return true;
        }

        @Override
        public MessageEvent poll() {
            MessageEvent e = this.queue.poll();
            if (e != null) {
                int messageSize = this.getMessageSize(e);
                int newWriteBufferSize = AbstractNioChannel.this.writeBufferSize.addAndGet(-messageSize);
                int lowWaterMark = AbstractNioChannel.this.getConfig().getWriteBufferLowWaterMark();
                if ((newWriteBufferSize == 0 || newWriteBufferSize < lowWaterMark) && newWriteBufferSize + messageSize >= lowWaterMark) {
                    AbstractNioChannel.this.highWaterMarkCounter.decrementAndGet();
                    if (AbstractNioChannel.this.isConnected() && !((Boolean)this.notifying.get()).booleanValue()) {
                        this.notifying.set(Boolean.TRUE);
                        Channels.fireChannelInterestChanged(AbstractNioChannel.this);
                        this.notifying.set(Boolean.FALSE);
                    }
                }
            }
            return e;
        }

        private int getMessageSize(MessageEvent e) {
            Object m = e.getMessage();
            if (m instanceof ChannelBuffer) {
                return ((ChannelBuffer)m).readableBytes();
            }
            return 0;
        }
    }
}

