/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.ognl;

import java.util.Map;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;

public abstract class AbstractPropertyAccessor
extends ObjectPropertyAccessor {
    static final Object READ_ONLY_MODE = new Object();
    static final Object QUERY = new Object();

    @Override
    public final boolean hasGetProperty(OgnlContext context, Object target, Object oname) throws OgnlException {
        if (oname == null) {
            return false;
        }
        if (this.hasGetProperty0(context, target, oname.toString())) {
            return true;
        }
        return super.hasGetProperty(context, target, oname);
    }

    @Override
    public final boolean hasSetProperty(OgnlContext context, Object target, Object oname) throws OgnlException {
        if (context.containsKey(READ_ONLY_MODE)) {
            return true;
        }
        if (oname == null) {
            return false;
        }
        if (this.hasSetProperty0(context, target, oname.toString())) {
            return true;
        }
        return super.hasSetProperty(context, target, oname);
    }

    @Override
    public final Object getPossibleProperty(Map context, Object target, String name) throws OgnlException {
        Object answer = this.getProperty0((OgnlContext)context, target, name);
        if (answer == OgnlRuntime.NotFound) {
            answer = super.getPossibleProperty(context, target, name);
        }
        return answer;
    }

    @Override
    public final Object setPossibleProperty(Map context, Object target, String name, Object value) throws OgnlException {
        if (context.containsKey(READ_ONLY_MODE)) {
            throw new OgnlException("Expression must be read-only: " + context.get(QUERY));
        }
        Object answer = this.setProperty0((OgnlContext)context, target, name, value);
        if (answer == OgnlRuntime.NotFound) {
            answer = super.setPossibleProperty(context, target, name, value);
        }
        return answer;
    }

    protected abstract boolean hasGetProperty0(OgnlContext var1, Object var2, String var3) throws OgnlException;

    protected abstract boolean hasSetProperty0(OgnlContext var1, Object var2, String var3) throws OgnlException;

    protected abstract Object getProperty0(OgnlContext var1, Object var2, String var3) throws OgnlException;

    protected abstract Object setProperty0(OgnlContext var1, Object var2, String var3, Object var4) throws OgnlException;

    @Override
    public final Object getProperty(Map context, Object target, Object oname) throws OgnlException {
        return super.getProperty(context, target, oname);
    }

    @Override
    public final boolean hasGetProperty(Map context, Object target, Object oname) throws OgnlException {
        return super.hasGetProperty(context, target, oname);
    }

    @Override
    public final boolean hasSetProperty(Map context, Object target, Object oname) throws OgnlException {
        return super.hasSetProperty(context, target, oname);
    }

    @Override
    public final void setProperty(Map context, Object target, Object oname, Object value) throws OgnlException {
        super.setProperty(context, target, oname, value);
    }
}

