/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.jmx;

import java.net.SocketAddress;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import ognl.Ognl;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.integration.jmx.IoSessionMBean;
import org.apache.mina.integration.jmx.ObjectMBean;
import org.apache.mina.integration.ognl.IoSessionFinder;

public class IoServiceMBean
extends ObjectMBean<IoService> {
    static String getSessionIdAsString(long l) {
        String id = Long.toHexString(l).toUpperCase();
        while (id.length() < 8) {
            id = '0' + id;
        }
        id = "0x" + id;
        return id;
    }

    public IoServiceMBean(IoService source) {
        super(source);
    }

    @Override
    protected Object invoke0(String name, Object[] params, String[] signature) throws Exception {
        if (name.equals("findSessions")) {
            IoSessionFinder finder = new IoSessionFinder((String)params[0]);
            return finder.find(((IoService)this.getSource()).getManagedSessions().values());
        }
        if (name.equals("findAndRegisterSessions")) {
            IoSessionFinder finder = new IoSessionFinder((String)params[0]);
            LinkedHashSet<IoSession> registeredSessions = new LinkedHashSet<IoSession>();
            for (IoSession s : finder.find(((IoService)this.getSource()).getManagedSessions().values())) {
                try {
                    this.getServer().registerMBean(new IoSessionMBean(s), new ObjectName(this.getName().getDomain() + ":type=session,name=" + IoServiceMBean.getSessionIdAsString(s.getId())));
                    registeredSessions.add(s);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to register a session as a MBean: " + s, (Throwable)e);
                }
            }
            return registeredSessions;
        }
        if (name.equals("findAndProcessSessions")) {
            IoSessionFinder finder = new IoSessionFinder((String)params[0]);
            String command = (String)params[1];
            Object expr = Ognl.parseExpression(command);
            Set<IoSession> matches = finder.find(((IoService)this.getSource()).getManagedSessions().values());
            for (IoSession s : matches) {
                try {
                    Ognl.getValue(expr, (Object)s);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to execute '" + command + "' for: " + s, (Throwable)e);
                }
            }
            return matches;
        }
        return super.invoke0(name, params, signature);
    }

    @Override
    protected void addExtraOperations(List<ModelMBeanOperationInfo> operations) {
        operations.add(new ModelMBeanOperationInfo("findSessions", "findSessions", new MBeanParameterInfo[]{new MBeanParameterInfo("ognlQuery", String.class.getName(), "a boolean OGNL expression")}, Set.class.getName(), 0));
        operations.add(new ModelMBeanOperationInfo("findAndRegisterSessions", "findAndRegisterSessions", new MBeanParameterInfo[]{new MBeanParameterInfo("ognlQuery", String.class.getName(), "a boolean OGNL expression")}, Set.class.getName(), 2));
        operations.add(new ModelMBeanOperationInfo("findAndProcessSessions", "findAndProcessSessions", new MBeanParameterInfo[]{new MBeanParameterInfo("ognlQuery", String.class.getName(), "a boolean OGNL expression"), new MBeanParameterInfo("ognlCommand", String.class.getName(), "an OGNL expression that modifies the state of the sessions in the match result")}, Set.class.getName(), 2));
    }

    @Override
    protected boolean isOperation(String methodName, Class<?>[] paramTypes) {
        if (methodName.matches("(newSession|broadcast|(add|remove)Listener)")) {
            return false;
        }
        if ((methodName.equals("bind") || methodName.equals("unbind")) && (paramTypes.length > 1 || paramTypes.length == 1 && !SocketAddress.class.isAssignableFrom(paramTypes[0]))) {
            return false;
        }
        return super.isOperation(methodName, paramTypes);
    }
}

