/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.firewall;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionThrottleFilter
extends IoFilterAdapter {
    private static final long DEFAULT_TIME = 1000L;
    private long allowedInterval;
    private final Map<String, Long> clients;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionThrottleFilter.class);

    public ConnectionThrottleFilter() {
        this(1000L);
    }

    public ConnectionThrottleFilter(long allowedInterval) {
        this.allowedInterval = allowedInterval;
        this.clients = Collections.synchronizedMap(new HashMap());
    }

    public void setAllowedInterval(long allowedInterval) {
        this.allowedInterval = allowedInterval;
    }

    protected boolean isConnectionOk(IoSession session) {
        SocketAddress remoteAddress = session.getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)remoteAddress;
            long now = System.currentTimeMillis();
            if (this.clients.containsKey(addr.getAddress().getHostAddress())) {
                LOGGER.debug("This is not a new client");
                Long lastConnTime = this.clients.get(addr.getAddress().getHostAddress());
                this.clients.put(addr.getAddress().getHostAddress(), now);
                if (now - lastConnTime < this.allowedInterval) {
                    LOGGER.warn("Session connection interval too short");
                    return false;
                }
                return true;
            }
            this.clients.put(addr.getAddress().getHostAddress(), now);
            return true;
        }
        return false;
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (!this.isConnectionOk(session)) {
            LOGGER.warn("Connections coming in too fast; closing.");
            session.close(true);
        }
        nextFilter.sessionCreated(session);
    }
}

