/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent.ringbuffer;

import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.UnsafeAccess;
import uk.co.real_logic.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.agrona.concurrent.MessageHandler;
import uk.co.real_logic.agrona.concurrent.ringbuffer.RecordDescriptor;
import uk.co.real_logic.agrona.concurrent.ringbuffer.RingBuffer;
import uk.co.real_logic.agrona.concurrent.ringbuffer.RingBufferDescriptor;

public class ManyToOneRingBuffer
implements RingBuffer {
    public static final int PADDING_MSG_TYPE_ID = -1;
    private static final int INSUFFICIENT_CAPACITY = -2;
    private final int capacity;
    private final int maxMsgLength;
    private final int tailPositionIndex;
    private final int headCachePositionIndex;
    private final int headPositionIndex;
    private final int correlationIdCounterIndex;
    private final int consumerHeartbeatIndex;
    private final AtomicBuffer buffer;

    public ManyToOneRingBuffer(AtomicBuffer buffer) {
        this.buffer = buffer;
        RingBufferDescriptor.checkCapacity(buffer.capacity());
        this.capacity = buffer.capacity() - RingBufferDescriptor.TRAILER_LENGTH;
        buffer.verifyAlignment();
        this.maxMsgLength = this.capacity / 8;
        this.tailPositionIndex = this.capacity + RingBufferDescriptor.TAIL_POSITION_OFFSET;
        this.headCachePositionIndex = this.capacity + RingBufferDescriptor.HEAD_CACHE_POSITION_OFFSET;
        this.headPositionIndex = this.capacity + RingBufferDescriptor.HEAD_POSITION_OFFSET;
        this.correlationIdCounterIndex = this.capacity + RingBufferDescriptor.CORRELATION_COUNTER_OFFSET;
        this.consumerHeartbeatIndex = this.capacity + RingBufferDescriptor.CONSUMER_HEARTBEAT_OFFSET;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean write(int msgTypeId, DirectBuffer srcBuffer, int srcIndex, int length) {
        RecordDescriptor.checkTypeId(msgTypeId);
        this.checkMsgLength(length);
        boolean isSuccessful = false;
        AtomicBuffer buffer = this.buffer;
        int recordLength = length + 8;
        int requiredCapacity = BitUtil.align(recordLength, 8);
        int recordIndex = this.claimCapacity(buffer, requiredCapacity);
        if (-2 != recordIndex) {
            buffer.putLongOrdered(recordIndex, RecordDescriptor.makeHeader(-recordLength, msgTypeId));
            UnsafeAccess.UNSAFE.storeFence();
            buffer.putBytes(RecordDescriptor.encodedMsgOffset(recordIndex), srcBuffer, srcIndex, length);
            buffer.putIntOrdered(RecordDescriptor.lengthOffset(recordIndex), recordLength);
            isSuccessful = true;
        }
        return isSuccessful;
    }

    @Override
    public int read(MessageHandler handler) {
        return this.read(handler, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(MessageHandler handler, int messageCountLimit) {
        int bytesRead;
        int messagesRead = 0;
        AtomicBuffer buffer = this.buffer;
        long head = buffer.getLong(this.headPositionIndex);
        int capacity = this.capacity;
        int headIndex = (int)head & capacity - 1;
        int contiguousBlockLength = capacity - headIndex;
        try {
            int recordLength;
            for (bytesRead = 0; bytesRead < contiguousBlockLength && messagesRead < messageCountLimit; bytesRead += BitUtil.align(recordLength, 8)) {
                int recordIndex = headIndex + bytesRead;
                long header = buffer.getLongVolatile(recordIndex);
                recordLength = RecordDescriptor.recordLength(header);
                if (recordLength > 0) continue;
                break;
            }
        }
        finally {
            if (bytesRead != 0) {
                buffer.setMemory(headIndex, bytesRead, (byte)0);
                buffer.putLongOrdered(this.headPositionIndex, head + (long)bytesRead);
            }
        }
        return messagesRead;
    }

    @Override
    public int maxMsgLength() {
        return this.maxMsgLength;
    }

    @Override
    public long nextCorrelationId() {
        return this.buffer.getAndAddLong(this.correlationIdCounterIndex, 1L);
    }

    @Override
    public AtomicBuffer buffer() {
        return this.buffer;
    }

    @Override
    public void consumerHeartbeatTime(long time) {
        this.buffer.putLongOrdered(this.consumerHeartbeatIndex, time);
    }

    @Override
    public long consumerHeartbeatTime() {
        return this.buffer.getLongVolatile(this.consumerHeartbeatIndex);
    }

    @Override
    public long producerPosition() {
        return this.buffer.getLongVolatile(this.tailPositionIndex);
    }

    @Override
    public long consumerPosition() {
        return this.buffer.getLongVolatile(this.headPositionIndex);
    }

    @Override
    public int size() {
        long tail;
        long headBefore;
        long headAfter = this.buffer.getLongVolatile(this.headPositionIndex);
        do {
            headBefore = headAfter;
            tail = this.buffer.getLongVolatile(this.tailPositionIndex);
        } while ((headAfter = this.buffer.getLongVolatile(this.headPositionIndex)) != headBefore);
        return (int)(tail - headAfter);
    }

    @Override
    public boolean unblock() {
        AtomicBuffer buffer = this.buffer;
        int mask = this.capacity - 1;
        int consumerIndex = (int)(buffer.getLongVolatile(this.headPositionIndex) & (long)mask);
        int producerIndex = (int)(buffer.getLongVolatile(this.tailPositionIndex) & (long)mask);
        if (producerIndex == consumerIndex) {
            return false;
        }
        boolean unblocked = false;
        int length = buffer.getIntVolatile(consumerIndex);
        if (length < 0) {
            buffer.putLongOrdered(consumerIndex, RecordDescriptor.makeHeader(-length, -1));
            unblocked = true;
        } else if (0 == length) {
            int limit = producerIndex > consumerIndex ? producerIndex : this.capacity;
            int i = consumerIndex + 8;
            do {
                if (0 == (length = buffer.getIntVolatile(i))) continue;
                if (!ManyToOneRingBuffer.scanBackToConfirmStillZeroed(buffer, i, consumerIndex)) break;
                buffer.putLongOrdered(consumerIndex, RecordDescriptor.makeHeader(i - consumerIndex, -1));
                unblocked = true;
                break;
            } while ((i += 8) < limit);
        }
        return unblocked;
    }

    private static boolean scanBackToConfirmStillZeroed(AtomicBuffer buffer, int from, int limit) {
        boolean allZeros = true;
        for (int i = from - 8; i >= limit; i -= 8) {
            if (0 == buffer.getIntVolatile(i)) continue;
            allZeros = false;
            break;
        }
        return allZeros;
    }

    private void checkMsgLength(int length) {
        if (length > this.maxMsgLength) {
            String msg = String.format("encoded message exceeds maxMsgLength of %d, length=%d", this.maxMsgLength, length);
            throw new IllegalArgumentException(msg);
        }
    }

    private int claimCapacity(AtomicBuffer buffer, int requiredCapacity) {
        int tailIndex;
        int padding;
        long tail;
        int capacity = this.capacity;
        int tailPositionIndex = this.tailPositionIndex;
        int headCachePositionIndex = this.headCachePositionIndex;
        int mask = capacity - 1;
        long head = buffer.getLongVolatile(headCachePositionIndex);
        do {
            int availableCapacity;
            if (requiredCapacity > (availableCapacity = capacity - (int)((tail = buffer.getLongVolatile(tailPositionIndex)) - head))) {
                head = buffer.getLongVolatile(this.headPositionIndex);
                if (requiredCapacity > capacity - (int)(tail - head)) {
                    return -2;
                }
                buffer.putLongOrdered(headCachePositionIndex, head);
            }
            padding = 0;
            tailIndex = (int)tail & mask;
            int toBufferEndLength = capacity - tailIndex;
            if (requiredCapacity <= toBufferEndLength) continue;
            int headIndex = (int)head & mask;
            if (requiredCapacity > headIndex) {
                head = buffer.getLongVolatile(this.headPositionIndex);
                headIndex = (int)head & mask;
                if (requiredCapacity > headIndex) {
                    return -2;
                }
                buffer.putLongOrdered(headCachePositionIndex, head);
            }
            padding = toBufferEndLength;
        } while (!buffer.compareAndSetLong(tailPositionIndex, tail, tail + (long)requiredCapacity + (long)padding));
        if (0 != padding) {
            buffer.putLongOrdered(tailIndex, RecordDescriptor.makeHeader(padding, -1));
            tailIndex = 0;
        }
        return tailIndex;
    }
}

