/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent;

import java.util.concurrent.locks.LockSupport;
import uk.co.real_logic.agrona.concurrent.IdleStrategy;

public final class SleepingIdleStrategy
implements IdleStrategy {
    private final long sleepPeriodNs;

    public SleepingIdleStrategy(long sleepPeriodNs) {
        this.sleepPeriodNs = sleepPeriodNs;
    }

    @Override
    public void idle(int workCount) {
        if (workCount > 0) {
            return;
        }
        LockSupport.parkNanos(this.sleepPeriodNs);
    }

    @Override
    public void idle() {
        LockSupport.parkNanos(this.sleepPeriodNs);
    }

    @Override
    public void reset() {
    }
}

