/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.collections;

import java.util.function.Consumer;
import java.util.function.IntFunction;
import uk.co.real_logic.agrona.generation.DoNotSub;

public final class IntLruCache<E>
implements AutoCloseable {
    @DoNotSub
    private final int capacity;
    private final IntFunction<E> factory;
    private final Consumer<E> closer;
    private final int[] keys;
    private final Object[] values;
    @DoNotSub
    private int size;

    public IntLruCache(@DoNotSub int capacity, IntFunction<E> factory, Consumer<E> closer) {
        this.capacity = capacity;
        this.factory = factory;
        this.closer = closer;
        this.keys = new int[capacity];
        this.values = new Object[capacity];
        this.size = 0;
    }

    public E lookup(int key) {
        int size = this.size;
        int[] keys = this.keys;
        Object[] values = this.values;
        for (int i = 0; i < size; ++i) {
            if (keys[i] != key) continue;
            Object value = values[i];
            this.makeMostRecent(key, value, i);
            return (E)value;
        }
        E value = this.factory.apply(key);
        if (value != null) {
            if (size == this.capacity) {
                this.closer.accept(values[size - 1]);
            } else {
                this.size = ++size;
            }
            this.makeMostRecent(key, value, size - 1);
        }
        return value;
    }

    private void makeMostRecent(int key, Object value, @DoNotSub int fromIndex) {
        int[] keys = this.keys;
        Object[] values = this.values;
        for (int i = fromIndex; i > 0; --i) {
            keys[i] = keys[i - 1];
            values[i] = values[i - 1];
        }
        keys[0] = key;
        values[0] = value;
    }

    @DoNotSub
    public int capacity() {
        return this.capacity;
    }

    @Override
    public void close() {
        for (int i = 0; i < this.size; ++i) {
            this.closer.accept(this.values[i]);
        }
    }
}

