/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.socket;

import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.SocketSessionConfigEx;
import org.jboss.netty.channel.socket.SocketChannelConfig;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.kaazing.mina.netty.ChannelIoSessionConfig;

public abstract class SocketChannelIoSessionConfig<T extends SocketChannelConfig>
extends ChannelIoSessionConfig<T>
implements SocketSessionConfigEx {
    public SocketChannelIoSessionConfig(T channelConfig) {
        super(channelConfig);
    }

    @Override
    protected void doSetAll(IoSessionConfigEx config) {
        super.doSetAll(config);
        if (config instanceof SocketChannelIoSessionConfig) {
            SocketChannelIoSessionConfig socketConfig = (SocketChannelIoSessionConfig)config;
            if (socketConfig.isReceiveBufferSizeChanged()) {
                this.setReceiveBufferSize(socketConfig.getReceiveBufferSize());
            }
            if (socketConfig.isSendBufferSizeChanged()) {
                this.setSendBufferSize(socketConfig.getSendBufferSize());
            }
            if (socketConfig.isSoLingerChanged()) {
                this.setSoLinger(socketConfig.getSoLinger());
            }
            if (socketConfig.isTrafficClassChanged()) {
                this.setTrafficClass(socketConfig.getTrafficClass());
            }
            if (socketConfig.isKeepAliveChanged()) {
                this.setKeepAlive(socketConfig.isKeepAlive());
            }
            if (socketConfig.isOobInlineChanged()) {
                this.setOobInline(socketConfig.isOobInline());
            }
            if (socketConfig.isReuseAddressChanged()) {
                this.setReuseAddress(socketConfig.isReuseAddress());
            }
            if (socketConfig.isTcpNoDelayChanged()) {
                this.setTcpNoDelay(socketConfig.isTcpNoDelay());
            }
        } else if (config instanceof SocketSessionConfig) {
            SocketSessionConfig cfg = (SocketSessionConfig)((Object)config);
            this.setKeepAlive(cfg.isKeepAlive());
            this.setOobInline(cfg.isOobInline());
            this.setReceiveBufferSize(cfg.getReceiveBufferSize());
            this.setReuseAddress(cfg.isReuseAddress());
            this.setSendBufferSize(cfg.getSendBufferSize());
            this.setSoLinger(cfg.getSoLinger());
            this.setTcpNoDelay(cfg.isTcpNoDelay());
            cfg.getTrafficClass();
        }
    }

    @Override
    public int getReceiveBufferSize() {
        return ((SocketChannelConfig)this.channelConfig).getReceiveBufferSize();
    }

    @Override
    public int getSendBufferSize() {
        return ((SocketChannelConfig)this.channelConfig).getSendBufferSize();
    }

    @Override
    public int getSoLinger() {
        return ((SocketChannelConfig)this.channelConfig).getSoLinger();
    }

    @Override
    public int getTrafficClass() {
        return ((SocketChannelConfig)this.channelConfig).getTrafficClass();
    }

    @Override
    public boolean isKeepAlive() {
        return ((SocketChannelConfig)this.channelConfig).isKeepAlive();
    }

    @Override
    public boolean isOobInline() {
        return false;
    }

    @Override
    public boolean isReuseAddress() {
        return ((SocketChannelConfig)this.channelConfig).isReuseAddress();
    }

    @Override
    public boolean isTcpNoDelay() {
        return ((SocketChannelConfig)this.channelConfig).isTcpNoDelay();
    }

    @Override
    public void setKeepAlive(boolean keepAlive) {
        ((SocketChannelConfig)this.channelConfig).setKeepAlive(keepAlive);
    }

    @Override
    public void setOobInline(boolean oobInline) {
    }

    @Override
    public void setReceiveBufferSize(int receiveBufferSize) {
        ((SocketChannelConfig)this.channelConfig).setReceiveBufferSize(receiveBufferSize);
    }

    @Override
    public void setReuseAddress(boolean reuseAddress) {
        ((SocketChannelConfig)this.channelConfig).setReuseAddress(reuseAddress);
    }

    @Override
    public void setSendBufferSize(int sendBufferSize) {
        ((SocketChannelConfig)this.channelConfig).setSendBufferSize(sendBufferSize);
    }

    @Override
    public void setSoLinger(int soLinger) {
        ((SocketChannelConfig)this.channelConfig).setSoLinger(soLinger);
    }

    @Override
    public void setTcpNoDelay(boolean tcpNoDelay) {
        ((SocketChannelConfig)this.channelConfig).setTcpNoDelay(tcpNoDelay);
    }

    @Override
    public void setTrafficClass(int trafficClass) {
        ((SocketChannelConfig)this.channelConfig).setTrafficClass(trafficClass);
    }

    protected boolean isKeepAliveChanged() {
        return true;
    }

    protected boolean isOobInlineChanged() {
        return true;
    }

    protected boolean isReceiveBufferSizeChanged() {
        return true;
    }

    protected boolean isReuseAddressChanged() {
        return true;
    }

    protected boolean isSendBufferSizeChanged() {
        return true;
    }

    protected boolean isSoLingerChanged() {
        return true;
    }

    protected boolean isTcpNoDelayChanged() {
        return true;
    }

    protected boolean isTrafficClassChanged() {
        return true;
    }
}

