/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty;

import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.session.IoSessionInitializer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.kaazing.mina.netty.ChannelIoService;
import org.kaazing.mina.netty.ChannelIoSession;
import org.kaazing.mina.netty.IoSessionChannelHandler;
import org.kaazing.mina.netty.buffer.ByteBufferWrappingChannelBufferFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoSessionFactoryChannelHandler
extends SimpleChannelHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoSessionFactoryChannelHandler.class);
    private final ChannelIoService service;
    private final ConnectFuture future;
    private final IoSessionInitializer<?> initializer;

    public IoSessionFactoryChannelHandler(ChannelIoService service, ConnectFuture future, IoSessionInitializer<?> initializer) {
        this.service = service;
        this.future = future;
        this.initializer = initializer;
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (ByteBufferWrappingChannelBufferFactory.OPTIMIZE_PERFORMANCE_CLIENT) {
            channel.getConfig().setBufferFactory(ByteBufferWrappingChannelBufferFactory.CHANNEL_BUFFER_FACTORY);
        }
        ChannelIoSession<?> session = this.service.createSession(channel);
        String baseName = ctx.getName();
        String name = String.format("%s#session", baseName);
        IoSessionChannelHandler handler = new IoSessionChannelHandler(session, this.future, this.initializer, this.service.getSessionIdleTracker());
        ChannelPipeline pipeline = ctx.getPipeline();
        pipeline.addAfter(baseName, name, handler);
        ctx.sendUpstream(e);
        pipeline.remove(this);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (this.future != null) {
            this.future.setException(e.getCause());
        } else {
            LOGGER.error("Exception caught in IoSessionFactoryChannelHandler", e.getCause());
            ctx.sendUpstream(e);
        }
    }
}

