/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty;

import java.util.concurrent.Executor;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.kaazing.mina.core.filterchain.DefaultIoFilterChainEx;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.netty.ChannelIoService;
import org.kaazing.mina.netty.ChannelIoSession;
import org.kaazing.mina.netty.DefaultChannelIoSessionConfig;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;

public class DefaultChannelIoSession
extends ChannelIoSession<ChannelConfig> {
    private static final ThreadLocal<Executor> CREATION_ALIGNED_EXECUTOR = new VicariousThreadLocal<Executor>(){

        @Override
        protected Executor initialValue() {
            return new CreationAlignedExecutor(Thread.currentThread());
        }
    };

    public DefaultChannelIoSession(ChannelIoService service, IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> processor, Channel channel) {
        super(service, processor, channel, new DefaultChannelIoSessionConfig(), Thread.currentThread(), CREATION_ALIGNED_EXECUTOR.get());
    }

    private static final class CreationAlignedExecutor
    implements Executor {
        private final Thread creationThread;

        public CreationAlignedExecutor(Thread creationThread) {
            this.creationThread = creationThread;
        }

        @Override
        public void execute(Runnable command) {
            if (Thread.currentThread() != this.creationThread && !DefaultIoFilterChainEx.CallNextSessionIdleCommand.class.equals(command.getClass())) {
                throw new UnsupportedOperationException(String.format("Current thread %s is different from session creator thread %s", Thread.currentThread(), this.creationThread));
            }
        }
    }
}

