/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.filter.codec.statemachine;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;

public abstract class FixedLengthDecodingState
implements DecodingState {
    protected final IoBufferAllocatorEx<?> allocator;
    private final int length;
    private IoBufferEx buffer;

    public FixedLengthDecodingState(IoBufferAllocatorEx<?> allocator, int length) {
        this.allocator = allocator;
        this.length = length;
    }

    @Override
    public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        IoBufferEx inEx = (IoBufferEx)((Object)in);
        if (this.buffer == null) {
            if (in.remaining() >= this.length) {
                int limit = in.limit();
                in.limit(in.position() + this.length);
                IoBufferEx product = inEx.slice();
                in.position(in.position() + this.length);
                in.limit(limit);
                return this.finishDecode((IoBuffer)((Object)product), out);
            }
            this.buffer = this.allocator.wrap(this.allocator.allocate(this.length));
            this.buffer.put(inEx);
            return this;
        }
        if (in.remaining() >= this.length - this.buffer.position()) {
            int limit = in.limit();
            in.limit(in.position() + this.length - this.buffer.position());
            this.buffer.put(inEx);
            in.limit(limit);
            this.buffer.flip();
            IoBufferEx product = this.buffer;
            this.buffer = null;
            return this.finishDecode((IoBuffer)((Object)product), out);
        }
        this.buffer.put(inEx);
        return this;
    }

    @Override
    public DecodingState finishDecode(ProtocolDecoderOutput out) throws Exception {
        IoBufferEx readData;
        if (this.buffer == null) {
            readData = this.allocator.wrap(this.allocator.allocate(0));
        } else {
            this.buffer.flip();
            readData = this.buffer;
            this.buffer = null;
        }
        return this.finishDecode((IoBuffer)((Object)readData), out);
    }

    protected abstract DecodingState finishDecode(IoBuffer var1, ProtocolDecoderOutput var2) throws Exception;
}

