/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.polling.AbstractPollingIoProcessor;
import org.apache.mina.core.session.SessionState;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.transport.socket.nio.NioSessionEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.buffer.SimpleBufferAllocator;

public final class NioProcessorEx
extends AbstractPollingIoProcessor<NioSessionEx> {
    private final Selector selector;

    public NioProcessorEx(Executor executor) {
        super(executor);
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new RuntimeIoException("Failed to open a selector.", e);
        }
    }

    @Override
    protected Object getWriteRequestMessage(NioSessionEx session, WriteRequest writeRequest) {
        IoBufferEx writeBuffer = session.getIncompleteSharedWriteBuffer();
        if (writeBuffer != null) {
            assert (!writeBuffer.isShared());
            return writeBuffer;
        }
        return writeRequest.getMessage();
    }

    @Override
    protected int writeBuffer(NioSessionEx session, WriteRequest req, IoBuffer buf, boolean hasFragmentation, int maxLength, long currentTime) throws Exception {
        if (!buf.hasRemaining()) {
            return super.writeBuffer(session, req, buf, hasFragmentation, maxLength, currentTime);
        }
        IoBufferEx bufEx = (IoBufferEx)((Object)buf);
        if (!bufEx.isShared()) {
            int remaining = buf.remaining();
            int localWrittenBytes = super.writeBuffer(session, req, buf, hasFragmentation, maxLength, currentTime);
            if (localWrittenBytes == remaining) {
                session.setIncompleteSharedWriteBuffer(null);
            }
            return localWrittenBytes;
        }
        ByteBuffer nioBuf = buf.buf();
        int position = nioBuf.position();
        int remaining = nioBuf.remaining();
        int localWrittenBytes = super.writeBuffer(session, req, buf, hasFragmentation, maxLength, currentTime);
        if (localWrittenBytes < remaining) {
            IoBufferEx incomplete = bufEx.asUnsharedBuffer();
            session.setIncompleteSharedWriteBuffer(incomplete);
            nioBuf.position(position);
        }
        return localWrittenBytes;
    }

    @Override
    protected void dispose0() throws Exception {
        this.selector.close();
    }

    @Override
    protected int select(long timeout) throws Exception {
        return this.selector.select(timeout);
    }

    @Override
    protected int select() throws Exception {
        return this.selector.select();
    }

    @Override
    protected boolean isSelectorEmpty() {
        return this.selector.keys().isEmpty();
    }

    @Override
    protected void wakeup() {
        this.selector.wakeup();
    }

    @Override
    protected Iterator<NioSessionEx> allSessions() {
        return new IoSessionIterator(this.selector.keys());
    }

    @Override
    protected Iterator<NioSessionEx> selectedSessions() {
        return new IoSessionIterator(this.selector.selectedKeys());
    }

    @Override
    protected void init(NioSessionEx session) throws Exception {
        SelectableChannel ch = (SelectableChannel)((Object)session.getChannel());
        ch.configureBlocking(false);
        session.setSelectionKey(ch.register(this.selector, 1, session));
    }

    @Override
    protected void destroy(NioSessionEx session) throws Exception {
        ByteChannel ch = session.getChannel();
        SelectionKey key = session.getSelectionKey();
        if (key != null) {
            key.cancel();
        }
        ch.close();
    }

    @Override
    protected SessionState getState(NioSessionEx session) {
        SelectionKey key = session.getSelectionKey();
        if (key == null) {
            return SessionState.OPENING;
        }
        if (key.isValid()) {
            return SessionState.OPENED;
        }
        return SessionState.CLOSING;
    }

    @Override
    protected boolean isReadable(NioSessionEx session) {
        SelectionKey key = session.getSelectionKey();
        return key.isValid() && key.isReadable();
    }

    @Override
    protected boolean isWritable(NioSessionEx session) {
        SelectionKey key = session.getSelectionKey();
        return key.isValid() && key.isWritable();
    }

    @Override
    protected boolean isInterestedInRead(NioSessionEx session) {
        SelectionKey key = session.getSelectionKey();
        return key.isValid() && (key.interestOps() & 1) != 0;
    }

    @Override
    protected boolean isInterestedInWrite(NioSessionEx session) {
        SelectionKey key = session.getSelectionKey();
        return key.isValid() && (key.interestOps() & 4) != 0;
    }

    @Override
    protected void setInterestedInRead(NioSessionEx session, boolean isInterested) throws Exception {
        int oldInterestOps;
        SelectionKey key = session.getSelectionKey();
        int newInterestOps = oldInterestOps = key.interestOps();
        newInterestOps = isInterested ? (newInterestOps |= 1) : (newInterestOps &= 0xFFFFFFFE);
        if (oldInterestOps != newInterestOps) {
            key.interestOps(newInterestOps);
        }
    }

    @Override
    protected void setInterestedInWrite(NioSessionEx session, boolean isInterested) throws Exception {
        int oldInterestOps;
        SelectionKey key = session.getSelectionKey();
        int newInterestOps = oldInterestOps = key.interestOps();
        newInterestOps = isInterested ? (newInterestOps |= 4) : (newInterestOps &= 0xFFFFFFFB);
        if (oldInterestOps != newInterestOps) {
            key.interestOps(newInterestOps);
        }
    }

    @Override
    protected IoBuffer newReadBuffer(int readBufferSize) {
        return SimpleBufferAllocator.BUFFER_ALLOCATOR.wrap(ByteBuffer.allocate(readBufferSize));
    }

    @Override
    protected int read(NioSessionEx session, IoBuffer buf) throws Exception {
        return session.getChannel().read(buf.buf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int write(NioSessionEx session, IoBuffer buf, int length) throws Exception {
        if (buf.remaining() <= length) {
            return session.getChannel().write(buf.buf());
        }
        int oldLimit = buf.limit();
        buf.limit(buf.position() + length);
        try {
            int n = session.getChannel().write(buf.buf());
            return n;
        }
        finally {
            buf.limit(oldLimit);
        }
    }

    @Override
    protected int transferFile(NioSessionEx session, FileRegion region, int length) throws Exception {
        try {
            return (int)region.getFileChannel().transferTo(region.getPosition(), length, session.getChannel());
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null && message.contains("temporarily unavailable")) {
                return 0;
            }
            throw e;
        }
    }

    protected static final class IoSessionIterator
    implements Iterator<NioSessionEx> {
        private final Iterator<SelectionKey> iterator;

        private IoSessionIterator(Set<SelectionKey> keys) {
            this.iterator = keys.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public NioSessionEx next() {
            SelectionKey key = this.iterator.next();
            NioSessionEx nioSession = (NioSessionEx)key.attachment();
            return nioSession;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

