/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.Verify;
import uk.co.real_logic.agrona.collections.CollectionUtil;
import uk.co.real_logic.agrona.collections.Hashing;
import uk.co.real_logic.agrona.collections.LongIterator;
import uk.co.real_logic.agrona.generation.DoNotSub;

public final class LongHashSet
implements Set<Long> {
    public static final double DEFAULT_LOAD_FACTOR = 0.67;
    @DoNotSub
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    private final double loadFactor;
    private final long missingValue;
    @DoNotSub
    private int resizeThreshold;
    @DoNotSub
    private int size;
    private long[] values;
    private final LongIterator iterator;

    public LongHashSet(long missingValue) {
        this(8, missingValue);
    }

    public LongHashSet(@DoNotSub int proposedCapacity, long missingValue) {
        this(proposedCapacity, missingValue, 0.67);
    }

    public LongHashSet(@DoNotSub int initialCapacity, long missingValue, double loadFactor) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.size = 0;
        this.missingValue = missingValue;
        int capacity = BitUtil.findNextPositivePowerOfTwo(initialCapacity);
        this.resizeThreshold = (int)((double)capacity * loadFactor);
        this.values = new long[capacity];
        Arrays.fill(this.values, missingValue);
        this.iterator = new LongIterator(missingValue, this.values);
    }

    public long missingValue() {
        return this.missingValue;
    }

    @Override
    public boolean add(Long value) {
        return this.add((long)value);
    }

    @Override
    public boolean add(long value) {
        long[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != this.missingValue) {
            if (values[index] == value) {
                return false;
            }
            index = LongHashSet.next(index, mask);
        }
        values[index] = value;
        ++this.size;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length * 2;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(@DoNotSub int newCapacity) {
        int capacity = newCapacity;
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((double)newCapacity * this.loadFactor);
        long[] tempValues = new long[capacity];
        long missingValue = this.missingValue;
        Arrays.fill(tempValues, missingValue);
        for (long value : this.values) {
            if (value == missingValue) continue;
            int newHash = Hashing.hash(value, mask);
            while (tempValues[newHash] != missingValue) {
                ++newHash;
                newHash &= mask;
            }
            tempValues[newHash] = value;
        }
        this.values = tempValues;
    }

    @Override
    public boolean remove(Object value) {
        return value instanceof Long && this.remove((Long)value);
    }

    public boolean remove(long value) {
        long[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != this.missingValue) {
            if (values[index] == value) {
                values[index] = this.missingValue;
                this.compactChain(index);
                --this.size;
                return true;
            }
            index = LongHashSet.next(index, mask);
        }
        return false;
    }

    @DoNotSub
    private static int next(int index, int mask) {
        return index + 1 & mask;
    }

    @DoNotSub
    private void compactChain(int deleteIndex) {
        long[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        while (values[index = LongHashSet.next(index, mask)] != this.missingValue) {
            int hash = Hashing.hash(values[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            values[deleteIndex] = values[index];
            values[index] = this.missingValue;
            deleteIndex = index;
        }
        return;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(idealCapacity));
    }

    @Override
    public boolean contains(Object value) {
        return value instanceof Long && this.contains((Long)value);
    }

    public boolean contains(long value) {
        long[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != this.missingValue) {
            if (values[index] == value) {
                return true;
            }
            index = LongHashSet.next(index, mask);
        }
        return false;
    }

    @Override
    @DoNotSub
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public double loadFactor() {
        return this.loadFactor;
    }

    public long capacity() {
        return this.values.length;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, this.missingValue);
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends Long> coll) {
        return LongHashSet.conjunction(coll, x -> this.add((Long)x));
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return LongHashSet.conjunction(coll, this::contains);
    }

    public boolean containsAll(LongHashSet other) {
        boolean containsAll = true;
        long missingValue = this.missingValue;
        for (long value : this.values) {
            if (value == missingValue || other.contains(value)) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public LongHashSet difference(LongHashSet other) {
        Objects.requireNonNull(other);
        LongHashSet difference = null;
        long missingValue = this.missingValue;
        for (long value : this.values) {
            if (value == missingValue || other.contains(value)) continue;
            if (difference == null) {
                difference = new LongHashSet(this.size, missingValue);
            }
            difference.add(value);
        }
        return difference;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return LongHashSet.conjunction(coll, this::remove);
    }

    private static <T> boolean conjunction(Collection<T> collection, Predicate<T> predicate) {
        Objects.requireNonNull(collection);
        boolean acc = false;
        for (T t : collection) {
            acc |= predicate.test(t);
        }
        return acc;
    }

    public LongIterator iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    public void copy(LongHashSet that) {
        if (this.values.length != that.values.length) {
            throw new IllegalArgumentException("Cannot copy object: masks not equal");
        }
        if (this.missingValue != that.missingValue) {
            throw new IllegalArgumentException("Cannot copy object: missingValues not equal");
        }
        System.arraycopy(that.values, 0, this.values, 0, this.values.length);
        this.size = that.size;
    }

    public String toString() {
        return this.stream().map(x -> Long.toString(x)).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    public <T> T[] toArray(T[] longo) {
        Verify.notNull(longo, "longo");
        Class<Long> componentType = longo.getClass().getComponentType();
        if (!componentType.isAssignableFrom(Long.class)) {
            throw new ArrayStoreException("Cannot store Longs in array of type " + componentType);
        }
        int size = this.size;
        Object[] arrayCopy = longo.length >= size ? longo : (Object[])Array.newInstance(componentType, size);
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    @Override
    public Object[] toArray() {
        Object[] arrayCopy = new Object[this.size];
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    private void copyValues(Object[] arrayCopy) {
        LongIterator iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            arrayCopy[i] = iterator.next();
            ++i;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof LongHashSet) {
            LongHashSet otherSet = (LongHashSet)other;
            return otherSet.missingValue == this.missingValue && otherSet.size == this.size && this.containsAll(otherSet);
        }
        return false;
    }

    @Override
    @DoNotSub
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

