/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongFunction;
import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.collections.CollectionUtil;
import uk.co.real_logic.agrona.collections.Hashing;
import uk.co.real_logic.agrona.generation.DoNotSub;

public class Long2ObjectHashMap<V>
implements Map<Long, V> {
    private final double loadFactor;
    @DoNotSub
    private int resizeThreshold;
    @DoNotSub
    private int size;
    private long[] keys;
    private Object[] values;
    private final ValueCollection<V> valueCollection;
    private final KeySet keySet;
    private final EntrySet<V> entrySet;

    public Long2ObjectHashMap() {
        this(8, 0.67);
    }

    public Long2ObjectHashMap(@DoNotSub int initialCapacity, double loadFactor) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        int capacity = BitUtil.findNextPositivePowerOfTwo(initialCapacity);
        this.resizeThreshold = (int)((double)capacity * loadFactor);
        this.keys = new long[capacity];
        this.values = new Object[capacity];
        this.valueCollection = new ValueCollection();
        this.keySet = new KeySet();
        this.entrySet = new EntrySet();
    }

    public double loadFactor() {
        return this.loadFactor;
    }

    @DoNotSub
    public int capacity() {
        return this.values.length;
    }

    @DoNotSub
    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    @DoNotSub
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Long)key);
    }

    public boolean containsKey(long key) {
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        boolean found = false;
        while (null != this.values[index]) {
            if (key == this.keys[index]) {
                found = true;
                break;
            }
            ++index;
            index &= mask;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        if (null != value) {
            for (Object v : this.values) {
                if (!value.equals(v)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public V get(Object key) {
        return this.get((Long)key);
    }

    public V get(long key) {
        Object value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = this.values[index]) && key != this.keys[index]) {
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    public V computeIfAbsent(long key, LongFunction<? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction, "mappingFunction cannot be null");
        V value = this.get(key);
        if (value == null && (value = mappingFunction.apply(key)) != null) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public V put(Long key, V value) {
        return this.put((long)key, value);
    }

    @Override
    public V put(long key, V value) {
        Objects.requireNonNull(value, "Value cannot be null");
        Object oldValue = null;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != this.values[index]) {
            if (key == this.keys[index]) {
                oldValue = this.values[index];
                break;
            }
            ++index;
            index &= mask;
        }
        if (null == oldValue) {
            ++this.size;
            this.keys[index] = key;
        }
        this.values[index] = value;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return (V)oldValue;
    }

    @Override
    public V remove(Object key) {
        return this.remove((Long)key);
    }

    public V remove(long key) {
        Object value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = this.values[index])) {
            if (key == this.keys[index]) {
                this.values[index] = null;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.values, null);
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(idealCapacity));
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return this.valueCollection;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        return this.entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<Long, V> entry : this.entrySet()) {
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(@DoNotSub int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((double)newCapacity * this.loadFactor);
        long[] tempKeys = new long[newCapacity];
        Object[] tempValues = new Object[newCapacity];
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            long key = this.keys[i];
            int newHash = Hashing.hash(key, mask);
            while (null != tempValues[newHash]) {
                ++newHash;
                newHash &= mask;
            }
            tempKeys[newHash] = key;
            tempValues[newHash] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(@DoNotSub int deleteIndex) {
        int mask = this.values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            if (null == this.values[index &= mask]) break;
            int hash = Hashing.hash(this.keys[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            this.keys[deleteIndex] = this.keys[index];
            this.values[deleteIndex] = this.values[index];
            this.values[index] = null;
            deleteIndex = index;
        }
    }

    public class EntryIterator<V>
    extends AbstractIterator<Map.Entry<Long, V>>
    implements Map.Entry<Long, V> {
        @Override
        public Map.Entry<Long, V> next() {
            this.findNext();
            return this;
        }

        @Override
        public Long getKey() {
            return this.keys[this.position()];
        }

        @Override
        public V getValue() {
            return (V)this.values[this.position()];
        }

        @Override
        public V setValue(V value) {
            Objects.requireNonNull(value);
            int pos = this.position();
            Object oldValue = this.values[pos];
            this.values[pos] = value;
            return (V)oldValue;
        }
    }

    public class KeyIterator
    extends AbstractIterator<Long> {
        @Override
        public Long next() {
            return this.nextLong();
        }

        public long nextLong() {
            this.findNext();
            return this.keys[this.position()];
        }
    }

    public class ValueIterator<T>
    extends AbstractIterator<T> {
        @Override
        public T next() {
            this.findNext();
            return (T)this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        @DoNotSub
        private int posCounter;
        @DoNotSub
        private int stopCounter;
        private boolean isPositionValid = false;
        protected long[] keys;
        protected Object[] values;

        protected AbstractIterator() {
            this.reset();
        }

        @DoNotSub
        protected int position() {
            return this.posCounter & this.values.length - 1;
        }

        @Override
        public boolean hasNext() {
            int mask = this.values.length - 1;
            boolean hasNext = false;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (null == this.values[index]) continue;
                hasNext = true;
                break;
            }
            return hasNext;
        }

        protected void findNext() {
            int mask = this.values.length - 1;
            this.isPositionValid = false;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (null == this.values[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                return;
            }
            throw new NoSuchElementException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            this.values[position] = null;
            --Long2ObjectHashMap.this.size;
            Long2ObjectHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }

        void reset() {
            int capacity;
            this.keys = Long2ObjectHashMap.this.keys;
            this.values = Long2ObjectHashMap.this.values;
            int i = capacity = this.values.length;
            if (null != this.values[capacity - 1]) {
                int size = capacity;
                for (i = 0; i < size && null != this.values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + capacity;
        }
    }

    private class EntrySet<V>
    extends AbstractSet<Map.Entry<Long, V>> {
        private final EntryIterator<V> iterator;

        private EntrySet() {
            this.iterator = new EntryIterator();
        }

        @Override
        @DoNotSub
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public Iterator<Map.Entry<Long, V>> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }
    }

    private class ValueCollection<V>
    extends AbstractCollection<V> {
        private final ValueIterator<V> iterator;

        private ValueCollection() {
            this.iterator = new ValueIterator();
        }

        @Override
        @DoNotSub
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Long2ObjectHashMap.this.containsValue(o);
        }

        @Override
        public ValueIterator<V> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }
    }

    public class KeySet
    extends AbstractSet<Long> {
        private final KeyIterator iterator;

        public KeySet() {
            this.iterator = new KeyIterator();
        }

        @Override
        @DoNotSub
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Long2ObjectHashMap.this.containsKey(o);
        }

        public boolean contains(long key) {
            return Long2ObjectHashMap.this.containsKey(key);
        }

        public KeyIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public boolean remove(Object o) {
            return null != Long2ObjectHashMap.this.remove(o);
        }

        public boolean remove(long key) {
            return null != Long2ObjectHashMap.this.remove(key);
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }
    }
}

