/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.socket;

import java.net.InetSocketAddress;
import org.apache.mina.transport.socket.SocketAcceptorEx;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.SocketChannelConfig;
import org.kaazing.mina.netty.ChannelIoAcceptor;
import org.kaazing.mina.netty.bootstrap.ServerBootstrapFactory;
import org.kaazing.mina.netty.socket.SocketChannelIoSessionConfig;

public abstract class SocketChannelIoAcceptor
extends ChannelIoAcceptor<SocketChannelIoSessionConfig<? extends SocketChannelConfig>, ServerSocketChannelFactory, InetSocketAddress>
implements SocketAcceptorEx {
    private final SocketAcceptorConfig acceptorConfig;

    protected SocketChannelIoAcceptor(SocketChannelIoSessionConfig<? extends SocketChannelConfig> sessionConfig, ServerSocketChannelFactory channelFactory, ChannelHandler bindHandler) {
        this(sessionConfig, channelFactory, bindHandler, new SocketAcceptorConfig());
    }

    private SocketChannelIoAcceptor(SocketChannelIoSessionConfig<? extends SocketChannelConfig> sessionConfig, ServerSocketChannelFactory channelFactory, ChannelHandler bindHandler, SocketAcceptorConfig acceptorConfig) {
        super(sessionConfig, channelFactory, new SocketBindHandler(bindHandler, acceptorConfig), ServerBootstrapFactory.CONNECTED);
        this.acceptorConfig = acceptorConfig;
    }

    @Override
    public int getBacklog() {
        return this.acceptorConfig.backlog;
    }

    @Override
    public void setBacklog(int backlog) {
        this.acceptorConfig.backlog = backlog;
    }

    @Override
    public boolean isReuseAddress() {
        return this.acceptorConfig.reuseAddress;
    }

    @Override
    public void setReuseAddress(boolean reuseAddress) {
        this.acceptorConfig.reuseAddress = reuseAddress;
    }

    @Override
    public void setDefaultLocalAddress(InetSocketAddress localAddress) {
        super.setDefaultLocalAddress(localAddress);
    }

    private static final class SocketBindHandler
    extends SimpleChannelHandler {
        private final ChannelHandler bindHandler;
        private final SocketAcceptorConfig config;

        public SocketBindHandler(ChannelHandler bindHandler, SocketAcceptorConfig config) {
            this.bindHandler = bindHandler;
            this.config = config;
        }

        @Override
        public void bindRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            ChannelConfig channelConfig = ctx.getChannel().getConfig();
            channelConfig.setOption("reuseAddress", this.config.reuseAddress);
            channelConfig.setOption("backlog", this.config.backlog);
            super.bindRequested(ctx, e);
        }

        @Override
        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            String baseName = ctx.getName();
            String name = String.format("%s:socket", baseName);
            ctx.getPipeline().addAfter(baseName, name, this.bindHandler);
            super.channelOpen(ctx, e);
        }
    }

    private static final class SocketAcceptorConfig {
        private int backlog = 50;
        private boolean reuseAddress = true;

        private SocketAcceptorConfig() {
        }
    }
}

