/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.util.concurrent.Executors;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.InternetProtocolFamily;
import org.jboss.netty.channel.socket.nio.NioChildDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioChildDatagramPipelineSink;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramPipelineSink;
import org.jboss.netty.channel.socket.nio.NioDatagramWorker;
import org.jboss.netty.channel.socket.nio.NioDatagramWorkerPool;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.SelectorUtil;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ExternalResourceReleasable;

public class NioDatagramChannelFactory
implements DatagramChannelFactory {
    private final NioDatagramPipelineSink sink;
    private final NioChildDatagramPipelineSink childSink;
    private final WorkerPool<NioDatagramWorker> workerPool = new NioDatagramWorkerPool(Executors.newCachedThreadPool(), SelectorUtil.DEFAULT_IO_THREADS);
    private final WorkerPool<NioWorker> childPool = new NioWorkerPool(Executors.newCachedThreadPool(), SelectorUtil.DEFAULT_IO_THREADS);
    private final InternetProtocolFamily family;
    private boolean releasePool;

    public NioDatagramChannelFactory() {
        this(null);
    }

    public NioDatagramChannelFactory(InternetProtocolFamily family) {
        this.family = family;
        this.sink = new NioDatagramPipelineSink(this.workerPool);
        this.childSink = new NioChildDatagramPipelineSink(this.childPool);
        this.releasePool = true;
    }

    @Override
    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return new NioDatagramChannel(this, pipeline, this.sink, this.sink.nextWorker(), this.family);
    }

    public NioChildDatagramChannel newChildChannel(Channel parent, ChannelPipeline pipeline) {
        return new NioChildDatagramChannel(parent, (ChannelFactory)this, pipeline, (ChannelSink)this.childSink, this.childSink.nextWorker(), this.family);
    }

    @Override
    public void shutdown() {
        this.workerPool.shutdown();
        this.childPool.shutdown();
        if (this.releasePool) {
            this.releasePool();
        }
    }

    @Override
    public void releaseExternalResources() {
        this.workerPool.shutdown();
        this.childPool.shutdown();
        this.releasePool();
    }

    private void releasePool() {
        if (this.workerPool instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)this.workerPool)).releaseExternalResources();
        }
        if (this.childPool instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)this.childPool)).releaseExternalResources();
        }
    }
}

