/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import uk.co.real_logic.agrona.UnsafeAccess;
import uk.co.real_logic.agrona.concurrent.ManyToOneConcurrentLinkedQueuePadding1;
import uk.co.real_logic.agrona.concurrent.ManyToOneConcurrentLinkedQueuePadding2;

public class ManyToOneConcurrentLinkedQueue<E>
extends ManyToOneConcurrentLinkedQueuePadding2<E>
implements Queue<E> {
    private ManyToOneConcurrentLinkedQueuePadding1.Node<E> head = new ManyToOneConcurrentLinkedQueuePadding1.Node<Object>(null);

    public ManyToOneConcurrentLinkedQueue() {
        UnsafeAccess.UNSAFE.putOrderedObject(this, TAIL_OFFSET, this.head);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("element cannot be null");
        }
        ManyToOneConcurrentLinkedQueuePadding1.Node<E> newTail = new ManyToOneConcurrentLinkedQueuePadding1.Node<E>(e);
        ManyToOneConcurrentLinkedQueuePadding1.Node<E> prevTail = this.swapTail(newTail);
        prevTail.setNextOrdered(newTail);
        return true;
    }

    @Override
    public E remove() {
        E e = this.poll();
        if (null == e) {
            throw new NoSuchElementException("Queue is empty");
        }
        return e;
    }

    @Override
    public E poll() {
        E value = null;
        ManyToOneConcurrentLinkedQueuePadding1.Node node = this.head.next;
        if (null != node) {
            value = node.value;
            node.value = null;
            this.head = node;
        }
        return value;
    }

    @Override
    public E element() {
        E e = this.peek();
        if (null == e) {
            throw new NoSuchElementException("Queue is empty");
        }
        return e;
    }

    @Override
    public E peek() {
        ManyToOneConcurrentLinkedQueuePadding1.Node node = this.head.next;
        return null != node ? (E)node.value : null;
    }

    @Override
    public int size() {
        int size;
        ManyToOneConcurrentLinkedQueuePadding1.Node tail = this.tail;
        ManyToOneConcurrentLinkedQueuePadding1.Node<E> head = this.head;
        for (size = 0; head != tail && size < Integer.MAX_VALUE; ++size) {
            ManyToOneConcurrentLinkedQueuePadding1.Node next = head.next;
            while (null == next) {
                next = head.next;
            }
            head = next;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private ManyToOneConcurrentLinkedQueuePadding1.Node<E> swapTail(ManyToOneConcurrentLinkedQueuePadding1.Node<E> newTail) {
        return (ManyToOneConcurrentLinkedQueuePadding1.Node)UnsafeAccess.UNSAFE.getAndSetObject(this, TAIL_OFFSET, newTail);
    }
}

