/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.socket.nio;

import java.util.concurrent.Executor;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.socket.DatagramChannelConfig;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.NioChildDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.netty.ChannelIoService;
import org.kaazing.mina.netty.ChannelIoSession;
import org.kaazing.mina.netty.socket.DefaultDatagramChannelIoSessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NioDatagramChannelIoSession
extends ChannelIoSession<DatagramChannelConfig> {
    private static final IoFilter IDLE_FILTER = new NioDatagramIdleFilter();
    private static final Logger LOGGER = LoggerFactory.getLogger(NioDatagramChannelIoSession.class);

    NioDatagramChannelIoSession(ChannelIoService service, IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> processor, NioDatagramChannel channel) {
        super(service, processor, channel, new DefaultDatagramChannelIoSessionConfig(), Thread.currentThread(), NioDatagramChannelIoSession.asExecutor(channel.getWorker()));
        this.getFilterChain().addLast("udp#idle", IDLE_FILTER);
    }

    NioDatagramChannelIoSession(ChannelIoService service, IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> processor, NioChildDatagramChannel channel) {
        super(service, processor, channel, new DefaultDatagramChannelIoSessionConfig(), Thread.currentThread(), NioDatagramChannelIoSession.asExecutor(channel.getWorker()));
        this.getFilterChain().addLast("udp#idle", IDLE_FILTER);
    }

    @Override
    protected void setIoAlignment0(Thread ioThread, Executor ioExecutor) {
        NioChildDatagramChannel channel = (NioChildDatagramChannel)this.getChannel();
        if (ioExecutor == NO_EXECUTOR) {
            channel.setWorker(null);
        } else if (this.isClosedReceived()) {
            this.getProcessor().remove(this);
        } else {
            AbstractNioWorker newWorker = ((ChannelIoSession.WorkerExecutor)ioExecutor).worker;
            channel.getWorker().deregister(channel);
            channel.setWorker(newWorker);
            newWorker.register(channel);
        }
    }

    private static Executor asExecutor(AbstractNioWorker worker) {
        ChannelIoSession.WorkerExecutor executor = (ChannelIoSession.WorkerExecutor)CURRENT_WORKER.get();
        if (executor == null) {
            assert (NioDatagramChannelIoSession.isInIoThread(worker)) : "Session created from non-I/O thread";
            executor = new ChannelIoSession.WorkerExecutor(worker);
            CURRENT_WORKER.set(executor);
        }
        assert (executor.worker == worker) : "Worker does not match I/O thread";
        return executor;
    }

    private static boolean isInIoThread(AbstractNioWorker worker) {
        boolean aligned;
        final Thread[] ioThread = new Thread[]{null};
        worker.executeInIoThread(new Runnable(){

            @Override
            public void run() {
                ioThread[0] = Thread.currentThread();
            }
        });
        boolean bl = aligned = ioThread[0] == Thread.currentThread();
        assert (aligned) : String.format("Current thread %s does not match I/O thread %s", Thread.currentThread(), ioThread[0]);
        return aligned;
    }

    private static class NioDatagramIdleFilter
    extends IoFilterAdapter {
        private NioDatagramIdleFilter() {
        }

        @Override
        public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Closing udp session %s since it is idle", session));
            }
            session.close(false);
        }
    }
}

