/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.net.SocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.AbstractNioChannelSink;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.NioChildDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.kaazing.mina.netty.channel.DefaultChannelFutureEx;

class NioChildDatagramPipelineSink
extends AbstractNioChannelSink {
    private final WorkerPool<NioWorker> workerPool;

    NioChildDatagramPipelineSink(WorkerPool<NioWorker> workerPool) {
        this.workerPool = workerPool;
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        NioChildDatagramChannel childChannel = (NioChildDatagramChannel)e.getChannel();
        ChannelFuture childFuture = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    childChannel.worker.close(childChannel, childFuture);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent childMessageEvent = (MessageEvent)e;
            ParentMessageEvent parentMessageEvent = new ParentMessageEvent(childMessageEvent);
            ChannelFuture parentFuture = parentMessageEvent.getFuture();
            parentFuture.addListener(f -> childChannel.getWorker().executeInIoThread(() -> {
                if (f.isSuccess()) {
                    childFuture.setSuccess();
                } else {
                    childFuture.setFailure(f.getCause());
                }
            }));
            NioDatagramChannel parentChannel = (NioDatagramChannel)childChannel.getParent();
            boolean offered = parentChannel.writeBufferQueue.offer(parentMessageEvent);
            assert (offered);
            parentChannel.worker.writeFromUserCode(parentChannel);
        }
    }

    AbstractNioWorker nextWorker() {
        return this.workerPool.nextWorker();
    }

    private static final class ParentMessageEvent
    implements MessageEvent {
        private final MessageEvent delegate;
        private final ChannelFuture parentFuture;

        ParentMessageEvent(MessageEvent delegate) {
            this.delegate = delegate;
            this.parentFuture = new DefaultChannelFutureEx();
        }

        @Override
        public Object getMessage() {
            return this.delegate.getMessage();
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return this.delegate.getRemoteAddress();
        }

        @Override
        public Channel getChannel() {
            return this.delegate.getChannel();
        }

        @Override
        public ChannelFuture getFuture() {
            return this.parentFuture;
        }
    }
}

