/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty;

import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.session.IoSessionInitializer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.kaazing.mina.netty.ChannelIoConnector;
import org.kaazing.mina.netty.IoSessionFactoryChannelHandler;

public class IoConnectorChannelHandler
extends SimpleChannelUpstreamHandler {
    private final ChannelIoConnector<?, ?, ?> connector;
    private final ConnectFuture connectFuture;
    private final IoSessionInitializer<?> sessionInitializer;

    public IoConnectorChannelHandler(ChannelIoConnector<?, ?, ?> connector, ConnectFuture connectFuture, IoSessionInitializer<?> sessionInitializer) {
        this.connector = connector;
        this.connectFuture = connectFuture;
        this.sessionInitializer = sessionInitializer;
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        ChannelPipeline childPipeline = channel.getPipeline();
        IoSessionFactoryChannelHandler newHandler = new IoSessionFactoryChannelHandler(this.connector, this.connectFuture, this.sessionInitializer);
        childPipeline.replace(this, "factory", (ChannelHandler)newHandler);
        ChannelHandlerContext childCtx = childPipeline.getContext(newHandler);
        newHandler.channelConnected(childCtx, e);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.connectFuture.setException(e.getCause());
    }
}

