/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.AbstractNioSelector;
import org.jboss.netty.channel.socket.nio.Boss;
import org.jboss.netty.channel.socket.nio.NioAcceptedSocketChannel;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannel;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;

public final class NioServerBoss
extends AbstractNioSelector
implements Boss {
    private final Set<ChannelFuture> channelUnregisteredFutures = Collections.newSetFromMap(new ConcurrentHashMap());

    NioServerBoss(Executor bossExecutor) {
        super(bossExecutor);
    }

    NioServerBoss(Executor bossExecutor, ThreadNameDeterminer determiner) {
        super(bossExecutor, determiner);
    }

    void bind(NioServerSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        this.registerTask(new RegisterTask(channel, future, localAddress));
    }

    @Override
    protected void close(SelectionKey k) {
        NioServerSocketChannel ch = (NioServerSocketChannel)k.attachment();
        this.close(ch, Channels.succeededFuture(ch));
    }

    void close(final NioServerSocketChannel channel, final ChannelFuture closeFuture) {
        final boolean bound = channel.isBound();
        try {
            ChannelFuture channelUnregisteredFuture = Channels.future(channel);
            this.channelUnregisteredFutures.add(channelUnregisteredFuture);
            channel.socket.close();
            this.increaseCancelledKeys();
            if (this.wakenUp.compareAndSet(false, true)) {
                this.selector.wakeup();
            }
            channelUnregisteredFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    block6: {
                        if (future.isSuccess()) {
                            try {
                                if (channel.setClosed()) {
                                    closeFuture.setSuccess();
                                    if (bound) {
                                        Channels.fireChannelUnbound(channel);
                                    }
                                    Channels.fireChannelClosed(channel);
                                    break block6;
                                }
                                closeFuture.setSuccess();
                            }
                            catch (Throwable t) {
                                closeFuture.setFailure(t);
                                Channels.fireExceptionCaught(channel, t);
                            }
                        } else {
                            closeFuture.setFailure(future.getCause());
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            closeFuture.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    @Override
    protected void process(Selector selector) {
        Set<SelectionKey> selectedKeys;
        Iterator<ChannelFuture> iter = this.channelUnregisteredFutures.iterator();
        if (iter.hasNext()) {
            boolean isDebugEnabled = logger.isDebugEnabled();
            block7: do {
                ChannelFuture future = iter.next();
                Channel c = future.getChannel();
                for (SelectionKey key : selector.keys()) {
                    if (key.attachment() != c) continue;
                    if (!isDebugEnabled) continue block7;
                    logger.debug(String.format("Found channel selector key for channel %s still in selector key set. Waiting for next iteration when it is removed to mark the unregister future complete.", c));
                    continue block7;
                }
                future.setSuccess();
                iter.remove();
            } while (iter.hasNext());
        }
        if ((selectedKeys = selector.selectedKeys()).isEmpty()) {
            return;
        }
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            NioServerSocketChannel channel = (NioServerSocketChannel)k.attachment();
            try {
                SocketChannel acceptedSocket;
                while ((acceptedSocket = channel.socket.accept()) != null) {
                    NioServerBoss.registerAcceptedChannel(channel, acceptedSocket, this.thread);
                }
            }
            catch (CancelledKeyException e) {
                k.cancel();
                channel.close();
            }
            catch (SocketTimeoutException e) {
            }
            catch (ClosedChannelException e) {
            }
            catch (Throwable t) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to accept a connection.", t);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static void registerAcceptedChannel(NioServerSocketChannel parent, SocketChannel acceptedSocket, Thread currentThread) {
        block5: {
            try {
                ChannelSink sink = parent.getPipeline().getSink();
                ChannelPipeline pipeline = parent.getConfig().getPipelineFactory().getPipeline();
                NioWorker worker = parent.workerPool.nextWorker();
                worker.register(new NioAcceptedSocketChannel(parent.getFactory(), pipeline, parent, sink, acceptedSocket, worker, currentThread), null);
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to initialize an accepted socket.", e);
                }
                try {
                    acceptedSocket.close();
                }
                catch (IOException e2) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Failed to close a partially accepted socket.", e2);
                }
            }
        }
    }

    @Override
    protected int select(Selector selector) throws IOException {
        return selector.select();
    }

    @Override
    protected ThreadRenamingRunnable newThreadRenamingRunnable(int id, ThreadNameDeterminer determiner) {
        return new ThreadRenamingRunnable(this, "New I/O server boss #" + id, determiner);
    }

    @Override
    protected Runnable createRegisterTask(Channel channel, ChannelFuture future) {
        return new RegisterTask((NioServerSocketChannel)channel, future, null);
    }

    private final class RegisterTask
    implements Runnable {
        private final NioServerSocketChannel channel;
        private final ChannelFuture future;
        private final SocketAddress localAddress;

        public RegisterTask(NioServerSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
            this.channel = channel;
            this.future = future;
            this.localAddress = localAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bound = false;
            boolean registered = false;
            try {
                this.channel.socket.socket().bind(this.localAddress, this.channel.getConfig().getBacklog());
                bound = true;
                this.future.setSuccess();
                Channels.fireChannelBound(this.channel, (SocketAddress)this.channel.getLocalAddress());
                this.channel.socket.register(NioServerBoss.this.selector, 16, this.channel);
                registered = true;
            }
            catch (Throwable t) {
                this.future.setFailure(t);
                Channels.fireExceptionCaught(this.channel, t);
            }
            finally {
                if (!registered && bound) {
                    NioServerBoss.this.close(this.channel, this.future);
                }
            }
        }
    }
}

