/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty;

import java.util.concurrent.TimeUnit;
import org.apache.mina.core.session.IdleStatus;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.netty.IoSessionIdleTracker;

public final class DefaultIoSessionIdleTracker
implements IoSessionIdleTracker {
    static final long PRECISION = 100L;
    private final Timer timer = new HashedWheelTimer(100L, TimeUnit.MILLISECONDS);
    private static final Timeout NULL_TIMEOUT = new Timeout(){

        @Override
        public Timer getTimer() {
            return null;
        }

        @Override
        public TimerTask getTask() {
            return null;
        }

        @Override
        public boolean isExpired() {
            return true;
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public void cancel() {
        }
    };

    @Override
    public void addSession(IoSessionEx session) {
        IoSessionConfigEx config = session.getConfig();
        config.setChangeListener(new NotifyIdleChangeListener(session));
    }

    @Override
    public void removeSession(IoSessionEx session) {
        IoSessionConfigEx config = session.getConfig();
        config.setChangeListener(null);
    }

    @Override
    public void dispose() {
        this.timer.stop();
    }

    private final class NotifyWriterIdleTask
    extends NotifyIdleTask {
        public NotifyWriterIdleTask(IoSessionEx session) {
            super(session);
        }

        @Override
        protected void fireSessionIdle(IoSessionEx session) {
            session.getFilterChain().fireSessionIdle(IdleStatus.WRITER_IDLE);
        }

        @Override
        protected long getLastIdleTimeMillis() {
            return this.session.getLastIdleTime(IdleStatus.WRITER_IDLE);
        }

        @Override
        protected long getLastIoTimeMillis() {
            return this.session.getLastWriteTime();
        }
    }

    private final class NotifyReaderIdleTask
    extends NotifyIdleTask {
        public NotifyReaderIdleTask(IoSessionEx session) {
            super(session);
        }

        @Override
        protected void fireSessionIdle(IoSessionEx session) {
            session.getFilterChain().fireSessionIdle(IdleStatus.READER_IDLE);
        }

        @Override
        protected long getLastIdleTimeMillis() {
            return this.session.getLastIdleTime(IdleStatus.READER_IDLE);
        }

        @Override
        protected long getLastIoTimeMillis() {
            return this.session.getLastReadTime();
        }
    }

    private final class NotifyBothIdleTask
    extends NotifyIdleTask {
        public NotifyBothIdleTask(IoSessionEx session) {
            super(session);
        }

        @Override
        protected void fireSessionIdle(IoSessionEx session) {
            session.getFilterChain().fireSessionIdle(IdleStatus.BOTH_IDLE);
        }

        @Override
        protected long getLastIdleTimeMillis() {
            return this.session.getLastIdleTime(IdleStatus.BOTH_IDLE);
        }

        @Override
        protected long getLastIoTimeMillis() {
            return this.session.getLastIoTime();
        }
    }

    private abstract class NotifyIdleTask
    implements TimerTask {
        protected final IoSessionEx session;
        private volatile long idleTimeMillis;
        private volatile Timeout timeout = DefaultIoSessionIdleTracker.access$000();

        public NotifyIdleTask(IoSessionEx session) {
            this.session = session;
        }

        public final void reschedule(long idleTime, TimeUnit unit) {
            this.idleTimeMillis = unit.toMillis(idleTime);
            long startPoint = Math.max(this.getLastIoTimeMillis(), this.getLastIdleTimeMillis());
            long delayMillis = startPoint + this.idleTimeMillis - System.currentTimeMillis();
            this.reschedule(delayMillis);
        }

        private void reschedule(long delayMillis) {
            if (this.timeout != NULL_TIMEOUT) {
                this.timeout.cancel();
            }
            this.timeout = this.idleTimeMillis != 0L ? DefaultIoSessionIdleTracker.this.timer.newTimeout(this, delayMillis, TimeUnit.MILLISECONDS) : NULL_TIMEOUT;
        }

        @Override
        public final void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            long startPoint = Math.max(this.getLastIoTimeMillis(), this.getLastIdleTimeMillis());
            long timeUntilSessionIdle = startPoint + this.idleTimeMillis - System.currentTimeMillis();
            if (timeUntilSessionIdle <= 0L && this.idleTimeMillis != 0L) {
                if (this.session.getIoThread() != IoSessionEx.NO_THREAD && !this.session.isClosing()) {
                    this.fireSessionIdle(this.session);
                }
                this.reschedule(this.idleTimeMillis);
            } else {
                this.reschedule(timeUntilSessionIdle);
            }
        }

        protected abstract void fireSessionIdle(IoSessionEx var1);

        protected abstract long getLastIoTimeMillis();

        protected abstract long getLastIdleTimeMillis();
    }

    private final class NotifyIdleChangeListener
    implements IoSessionConfigEx.ChangeListener {
        private final NotifyIdleTask notifyBothIdle;
        private final NotifyIdleTask notifyReaderIdle;
        private final NotifyIdleTask notifyWriterIdle;

        NotifyIdleChangeListener(IoSessionEx session) {
            this.notifyBothIdle = new NotifyBothIdleTask(session);
            this.notifyReaderIdle = new NotifyReaderIdleTask(session);
            this.notifyWriterIdle = new NotifyWriterIdleTask(session);
        }

        @Override
        public void idleTimeInMillisChanged(IdleStatus status, long idleTimeMillis) {
            if (status == IdleStatus.BOTH_IDLE) {
                this.notifyBothIdle.reschedule(idleTimeMillis, TimeUnit.MILLISECONDS);
            } else if (status == IdleStatus.READER_IDLE) {
                this.notifyReaderIdle.reschedule(idleTimeMillis, TimeUnit.MILLISECONDS);
            } else if (status == IdleStatus.WRITER_IDLE) {
                this.notifyWriterIdle.reschedule(idleTimeMillis, TimeUnit.MILLISECONDS);
            } else {
                throw new IllegalArgumentException("Unrecognized idle status: " + status);
            }
        }
    }
}

