/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty;

import java.io.IOException;
import java.net.BindException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.session.IoSessionInitializer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.kaazing.mina.core.future.BindFuture;
import org.kaazing.mina.core.future.DefaultBindFuture;
import org.kaazing.mina.core.future.DefaultUnbindFuture;
import org.kaazing.mina.core.future.UnbindFuture;
import org.kaazing.mina.core.service.AbstractIoAcceptorEx;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.kaazing.mina.netty.ChannelIoProcessor;
import org.kaazing.mina.netty.ChannelIoService;
import org.kaazing.mina.netty.ChannelIoSession;
import org.kaazing.mina.netty.DefaultIoSessionIdleTracker;
import org.kaazing.mina.netty.IoAcceptorChannelHandler;
import org.kaazing.mina.netty.IoSessionIdleTracker;
import org.kaazing.mina.netty.bootstrap.ServerBootstrap;
import org.kaazing.mina.netty.bootstrap.ServerBootstrapFactory;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;

public abstract class ChannelIoAcceptor<C extends IoSessionConfigEx, F extends ChannelFactory, A extends SocketAddress>
extends AbstractIoAcceptorEx
implements ChannelIoService {
    private final ServerBootstrap bootstrap;
    private final Map<SocketAddress, Channel> boundChannels;
    private IoSessionInitializer<? extends IoFuture> initializer;
    private final IoAcceptorChannelHandler parentHandler;
    private final ChannelGroup channelGroup;
    private final IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> processor = new ChannelIoProcessor();
    private final List<IoSessionIdleTracker> sessionIdleTrackers = Collections.synchronizedList(new ArrayList());
    private final ThreadLocal<IoSessionIdleTracker> currentSessionIdleTracker = new VicariousThreadLocal<IoSessionIdleTracker>(){

        @Override
        protected IoSessionIdleTracker initialValue() {
            DefaultIoSessionIdleTracker result = new DefaultIoSessionIdleTracker();
            ChannelIoAcceptor.this.sessionIdleTrackers.add(result);
            return result;
        }
    };

    protected ChannelIoAcceptor(C sessionConfig, F channelFactory, ChannelHandler bindHandler, ServerBootstrapFactory bootstrapFactory) {
        super((IoSessionConfigEx)sessionConfig, new Executor(){

            @Override
            public void execute(Runnable command) {
            }
        });
        if (bindHandler == null) {
            throw new NullPointerException("bindHandler");
        }
        this.channelGroup = new DefaultChannelGroup();
        this.parentHandler = new IoAcceptorChannelHandler(this, this.channelGroup, bindHandler);
        this.bootstrap = bootstrapFactory.createBootstrap();
        this.bootstrap.setFactory((ChannelFactory)channelFactory);
        this.bootstrap.setParentHandler(this.parentHandler);
        this.boundChannels = new ConcurrentHashMap<SocketAddress, Channel>();
    }

    public IoSessionInitializer<? extends IoFuture> getIoSessionInitializer() {
        return this.initializer;
    }

    public void setIoSessionInitializer(IoSessionInitializer<? extends IoFuture> initializer) {
        this.initializer = initializer;
    }

    public void setPipelineFactory(ChannelPipelineFactory pipelineFactory) {
        this.parentHandler.setPipelineFactory(pipelineFactory);
    }

    @Override
    public IoSessionIdleTracker getSessionIdleTracker() {
        return this.currentSessionIdleTracker.get();
    }

    @Override
    public void initializeSession(ChannelIoSession<?> session, IoFuture future, IoSessionInitializer<?> initializer) {
        this.initSession(session, future, initializer);
    }

    protected F getChannelFactory() {
        return (F)this.bootstrap.getFactory();
    }

    protected IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> getProcessor() {
        return this.processor;
    }

    @Override
    protected Set<SocketAddress> bindInternal(List<? extends SocketAddress> localAddresses) throws Exception {
        for (SocketAddress socketAddress : localAddresses) {
            try {
                Channel channel = this.bootstrap.bind(socketAddress);
                this.boundChannels.put(socketAddress, channel);
            }
            catch (Exception exception) {
                BindException be = new BindException(String.format("Unable to bind address: %s", socketAddress));
                be.initCause(exception);
                be.fillInStackTrace();
                throw be;
            }
        }
        HashSet<SocketAddress> newLocalAddresses = new HashSet<SocketAddress>();
        for (SocketAddress socketAddress : localAddresses) {
            newLocalAddresses.add(socketAddress);
        }
        return newLocalAddresses;
    }

    @Override
    protected BindFuture bindAsyncInternal(final SocketAddress localAddress) {
        final DefaultBindFuture bound = new DefaultBindFuture();
        ChannelFuture channelBound = this.bootstrap.bindAsync(localAddress);
        channelBound.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    Channel channel = future.getChannel();
                    ChannelIoAcceptor.this.boundChannels.put(localAddress, channel);
                    bound.setBound();
                } else {
                    BindException be = new BindException(String.format("Unable to bind address: %s", localAddress));
                    be.initCause(future.getCause());
                    be.fillInStackTrace();
                    bound.setException(be);
                }
            }
        });
        return bound;
    }

    @Override
    protected void unbind0(List<? extends SocketAddress> localAddresses) throws Exception {
        for (SocketAddress socketAddress : localAddresses) {
            Channel channel = this.boundChannels.remove(socketAddress);
            if (channel == null) continue;
            ChannelFuture unbound = channel.close();
            unbound.awaitUninterruptibly();
            if (unbound.isSuccess()) continue;
            throw new IOException(unbound.getCause());
        }
    }

    @Override
    protected UnbindFuture unbindAsyncInternal(SocketAddress localAddress) {
        final DefaultUnbindFuture unbound = new DefaultUnbindFuture();
        Channel channel = this.boundChannels.remove(localAddress);
        ChannelFuture channelUnbound = channel.close();
        channelUnbound.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    unbound.setUnbound();
                } else {
                    unbound.setException(future.getCause());
                }
            }
        });
        return unbound;
    }

    public final ChannelIoSession<? extends ChannelConfig> createSession(Channel channel) {
        return this.createSession(channel, this.processor);
    }

    @Override
    public ChannelIoSession<? extends ChannelConfig> newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
        throw new UnsupportedOperationException();
    }

    protected abstract ChannelIoSession<? extends ChannelConfig> createSession(Channel var1, IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> var2);

    @Override
    protected IoFuture dispose0() throws Exception {
        this.channelGroup.close().await();
        this.unbind();
        this.bootstrap.releaseExternalResources();
        for (IoSessionIdleTracker tracker : this.sessionIdleTrackers) {
            tracker.dispose();
        }
        return null;
    }

    public C getSessionConfig() {
        return (C)super.getSessionConfig();
    }

    public A getDefaultLocalAddress() {
        return (A)super.getDefaultLocalAddress();
    }

    public A getLocalAddress() {
        return (A)super.getLocalAddress();
    }
}

