/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.filter.codec.statemachine;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;

public abstract class ConsumeToDynamicTerminatorDecodingState
implements DecodingState {
    private final IoBufferAllocatorEx<?> allocator;
    private IoBufferEx buffer;

    public ConsumeToDynamicTerminatorDecodingState(IoBufferAllocatorEx<?> allocator) {
        this.allocator = allocator;
    }

    @Override
    public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        int beginPos = in.position();
        int terminatorPos = -1;
        int limit = in.limit();
        for (int i = beginPos; i < limit; ++i) {
            byte b = in.get(i);
            if (!this.isTerminator(b)) continue;
            terminatorPos = i;
            break;
        }
        if (terminatorPos >= 0) {
            IoBufferEx product;
            if (beginPos < terminatorPos) {
                in.limit(terminatorPos);
                if (this.buffer == null) {
                    product = ((IoBufferEx)((Object)in)).slice();
                } else {
                    this.buffer.put((IoBufferEx)((Object)in));
                    product = this.buffer.flip();
                    this.buffer = null;
                }
                in.limit(limit);
            } else if (this.buffer == null) {
                product = this.allocator.wrap(this.allocator.allocate(0));
            } else {
                product = this.buffer.flip();
                this.buffer = null;
            }
            in.position(terminatorPos + 1);
            return this.finishDecode(product.asIoBuffer(), out);
        }
        if (this.buffer == null) {
            this.buffer = this.allocator.wrap(this.allocator.allocate(in.remaining()));
            this.buffer.setAutoExpander(this.allocator);
        }
        this.buffer.put((IoBufferEx)((Object)in));
        return this;
    }

    @Override
    public DecodingState finishDecode(ProtocolDecoderOutput out) throws Exception {
        IoBufferEx product;
        if (this.buffer == null) {
            product = this.allocator.wrap(this.allocator.allocate(0));
        } else {
            product = this.buffer.flip();
            this.buffer = null;
        }
        return this.finishDecode(product.asIoBuffer(), out);
    }

    protected abstract boolean isTerminator(byte var1);

    protected abstract DecodingState finishDecode(IoBuffer var1, ProtocolDecoderOutput var2) throws Exception;
}

