/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.filterchain.DefaultIoFilterChain;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.service.DefaultTransportMetadata;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.transport.socket.DefaultSocketSessionConfigEx;
import org.apache.mina.transport.socket.SocketSessionConfigEx;
import org.apache.mina.transport.socket.nio.NioSessionEx;
import org.kaazing.mina.core.service.IoServiceEx;

public class NioSocketSessionEx
extends NioSessionEx {
    static final TransportMetadata METADATA = new DefaultTransportMetadata("nio", "socket", false, true, InetSocketAddress.class, SocketSessionConfigEx.class, IoBuffer.class, FileRegion.class);
    private final IoServiceEx service;
    private final SocketSessionConfigEx config = new DefaultSocketSessionConfigEx();
    private final IoProcessor<NioSessionEx> processor;
    private final IoFilterChain filterChain = new DefaultIoFilterChain(this);
    private final SocketChannel ch;
    private final IoHandler handler;
    private SelectionKey key;

    public NioSocketSessionEx(IoServiceEx service, IoProcessor<NioSessionEx> processor, SocketChannel ch) {
        this.service = service;
        this.processor = processor;
        this.ch = ch;
        this.handler = service.getHandler();
    }

    public void initSessionConfig() throws RuntimeIoException {
        this.config.setAll(this.service.getSessionConfig());
    }

    @Override
    public int getIoLayer() {
        return 0;
    }

    @Override
    public IoServiceEx getService() {
        return this.service;
    }

    @Override
    public SocketSessionConfigEx getConfig() {
        return this.config;
    }

    @Override
    public IoProcessor<NioSessionEx> getProcessor() {
        return this.processor;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return METADATA;
    }

    @Override
    SocketChannel getChannel() {
        return this.ch;
    }

    @Override
    SelectionKey getSelectionKey() {
        return this.key;
    }

    @Override
    void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (this.ch == null) {
            return null;
        }
        Socket socket = this.ch.socket();
        if (socket == null) {
            return null;
        }
        return (InetSocketAddress)socket.getRemoteSocketAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (this.ch == null) {
            return null;
        }
        Socket socket = this.ch.socket();
        if (socket == null) {
            return null;
        }
        return (InetSocketAddress)socket.getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getServiceAddress() {
        return (InetSocketAddress)super.getServiceAddress();
    }
}

