/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.socket.nio;

import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.socket.DatagramChannelConfig;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramWorker;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.netty.ChannelIoService;
import org.kaazing.mina.netty.ChannelIoSession;
import org.kaazing.mina.netty.socket.DefaultDatagramChannelIoSessionConfig;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;

public class NioDatagramChannelIoSession
extends ChannelIoSession<DatagramChannelConfig> {
    private static final ThreadLocal<WorkerExecutor> WORKER_EXECUTOR = new VicariousThreadLocal<WorkerExecutor>();

    public NioDatagramChannelIoSession(ChannelIoService service, IoProcessorEx<ChannelIoSession<? extends ChannelConfig>> processor, NioDatagramChannel channel) {
        super(service, processor, channel, new DefaultDatagramChannelIoSessionConfig(), Thread.currentThread(), NioDatagramChannelIoSession.asExecutor(channel.getWorker()));
    }

    private static Executor asExecutor(NioDatagramWorker worker) {
        assert (NioDatagramChannelIoSession.isInIoThread(worker)) : "Session created from non-I/O thread";
        WorkerExecutor executor = WORKER_EXECUTOR.get();
        if (executor == null) {
            executor = new WorkerExecutor(worker);
            WORKER_EXECUTOR.set(executor);
        }
        assert (executor.worker == worker) : "Worker does not match I/O thread";
        return executor;
    }

    private static boolean isInIoThread(NioDatagramWorker worker) {
        boolean aligned;
        final Thread[] ioThread = new Thread[]{null};
        worker.executeInIoThread(new Runnable(){

            @Override
            public void run() {
                ioThread[0] = Thread.currentThread();
            }
        });
        boolean bl = aligned = ioThread[0] == Thread.currentThread();
        assert (aligned) : String.format("Current thread %s does not match I/O thread %s", Thread.currentThread(), ioThread[0]);
        return aligned;
    }

    private static final class WorkerExecutor
    implements Executor {
        private final NioDatagramWorker worker;

        WorkerExecutor(NioDatagramWorker worker) {
            this.worker = worker;
        }

        @Override
        public void execute(Runnable command) {
            this.worker.executeInIoThread(command, true);
        }
    }
}

