/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.jboss.netty.buffer.AbstractChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.DirectChannelBufferFactory;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.kaazing.mina.netty.buffer.ByteBufferWrappingChannelBufferFactory;

public final class ByteBufferWrappingChannelBuffer
extends AbstractChannelBuffer {
    private ByteBuffer buffer;
    private ByteOrder order;
    private int capacity;

    public ChannelBuffer wrap(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        int position = buffer.position();
        int limit = buffer.limit();
        this.order = buffer.order();
        this.buffer = buffer;
        this.capacity = buffer.capacity();
        this.setIndex(position, limit);
        return this;
    }

    private ChannelBuffer wrap(ByteBufferWrappingChannelBuffer buffer) {
        this.buffer = buffer.buffer;
        this.order = buffer.order;
        this.capacity = buffer.capacity;
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
        return this;
    }

    @Override
    public int readableBytes() {
        return this.buffer.remaining();
    }

    @Override
    public ChannelBufferFactory factory() {
        if (this.buffer.isDirect()) {
            return DirectChannelBufferFactory.getInstance(this.order());
        }
        return HeapChannelBufferFactory.getInstance(this.order());
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.get(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        return (this.getByte(index) & 0xFF) << 16 | (this.getByte(index + 1) & 0xFF) << 8 | this.getByte(index + 2) & 0xFF;
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        if (dst instanceof ByteBufferWrappingChannelBuffer) {
            ByteBufferWrappingChannelBuffer bbdst = (ByteBufferWrappingChannelBuffer)dst;
            ByteBuffer data = bbdst.buffer;
            int position = data.position();
            int limit = data.limit();
            data.limit(dstIndex + length).position(dstIndex);
            this.getBytes(index, data);
            data.limit(limit).position(position);
        } else if (this.buffer.hasArray()) {
            dst.setBytes(dstIndex, this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            dst.setBytes(dstIndex, this, index, length);
        }
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        ByteBuffer data = this.buffer;
        int position = data.position();
        int limit = data.limit();
        try {
            data.limit(index + length).position(index);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + length) + ", maximum is " + data.limit());
        }
        data.get(dst, dstIndex, length);
        data.limit(limit).position(position);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        ByteBuffer data = this.buffer;
        int bytesToCopy = Math.min(this.capacity() - index, dst.remaining());
        int position = data.position();
        int limit = data.limit();
        try {
            data.limit(index + bytesToCopy).position(index);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + bytesToCopy) + ", maximum is " + data.limit());
        }
        dst.put(data);
        data.limit(limit).position(position);
    }

    @Override
    public void setByte(int index, int value) {
        this.buffer.put(index, (byte)value);
    }

    @Override
    public void setShort(int index, int value) {
        this.buffer.putShort(index, (short)value);
    }

    @Override
    public void setMedium(int index, int value) {
        this.setByte(index, (byte)(value >>> 16));
        this.setByte(index + 1, (byte)(value >>> 8));
        this.setByte(index + 2, (byte)value);
    }

    @Override
    public void setInt(int index, int value) {
        this.buffer.putInt(index, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.buffer.putLong(index, value);
    }

    @Override
    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        if (src instanceof ByteBufferWrappingChannelBuffer) {
            ByteBufferWrappingChannelBuffer bbsrc = (ByteBufferWrappingChannelBuffer)src;
            ByteBuffer data = bbsrc.buffer.duplicate();
            data.limit(srcIndex + length).position(srcIndex);
            this.setBytes(index, data);
        } else if (this.buffer.hasArray()) {
            src.getBytes(srcIndex, this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            src.getBytes(srcIndex, this, index, length);
        }
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        ByteBuffer data = this.buffer.duplicate();
        data.limit(index + length).position(index);
        data.put(src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        if (index == 0) {
            this.wrap(src);
        } else if (this.buffer == null) {
            ByteBuffer data = src.duplicate();
            data.limit(index + src.remaining()).position(index);
            data.put(src);
        } else {
            ByteBuffer data = this.buffer.duplicate();
            data.limit(index + src.remaining()).position(index);
            data.put(src);
        }
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            byte[] tmp = new byte[length];
            ((ByteBuffer)this.buffer.duplicate().position(index)).get(tmp);
            out.write(tmp);
        }
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        return out.write((ByteBuffer)this.buffer.duplicate().position(index).limit(index + length));
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        int readBytes = 0;
        if (this.buffer.hasArray()) {
            int localReadBytes;
            index += this.buffer.arrayOffset();
            do {
                if ((localReadBytes = in.read(this.buffer.array(), index, length)) < 0) {
                    if (readBytes == 0) {
                        return -1;
                    }
                    break;
                }
                readBytes += localReadBytes;
                index += localReadBytes;
            } while ((length -= localReadBytes) > 0);
        } else {
            int localReadBytes;
            byte[] tmp = new byte[length];
            int i = 0;
            do {
                if ((localReadBytes = in.read(tmp, i, tmp.length - i)) >= 0) continue;
                if (readBytes != 0) break;
                return -1;
            } while ((i += (readBytes += localReadBytes)) < tmp.length);
            ((ByteBuffer)this.buffer.duplicate().position(index)).put(tmp);
        }
        return readBytes;
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        int readBytes;
        int localReadBytes;
        ByteBuffer slice = (ByteBuffer)this.buffer.duplicate().limit(index + length).position(index);
        for (readBytes = 0; readBytes < length; readBytes += localReadBytes) {
            try {
                localReadBytes = in.read(slice);
            }
            catch (ClosedChannelException e) {
                localReadBytes = -1;
            }
            if (localReadBytes < 0) {
                if (readBytes == 0) {
                    return -1;
                }
                return readBytes;
            }
            if (localReadBytes == 0) break;
        }
        return readBytes;
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        if (index == 0 && length == this.capacity()) {
            return this.buffer.order(this.order());
        }
        if (ByteBufferWrappingChannelBufferFactory.OPTIMIZE_PERFORMANCE_CLIENT) {
            return ((ByteBuffer)this.buffer.position(index).limit(index + length)).order(this.order());
        }
        return ((ByteBuffer)this.buffer.duplicate().position(index).limit(index + length)).slice().order(this.order());
    }

    @Override
    public ChannelBuffer slice(int index, int length) {
        if (index == 0 && length == this.capacity()) {
            ChannelBuffer slice = this.duplicate();
            slice.setIndex(0, length);
            return slice;
        }
        if (index >= 0 && length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return new ByteBufferWrappingChannelBuffer().wrap(((ByteBuffer)this.buffer.duplicate().position(index).limit(index + length)).order(this.order()));
    }

    @Override
    public ChannelBuffer duplicate() {
        return new ByteBufferWrappingChannelBuffer().wrap(this);
    }

    @Override
    public ChannelBuffer copy(int index, int length) {
        ByteBuffer src;
        try {
            src = (ByteBuffer)this.buffer.duplicate().position(index).limit(index + length);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + length));
        }
        ByteBuffer dst = this.buffer.isDirect() ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        dst.put(src);
        dst.order(this.order());
        dst.clear();
        return new ByteBufferWrappingChannelBuffer().wrap(dst);
    }
}

