/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket;

import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.DatagramSessionConfigEx;
import org.kaazing.mina.core.session.AbstractIoSessionConfigEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;

public abstract class AbstractDatagramSessionConfigEx
extends AbstractIoSessionConfigEx
implements DatagramSessionConfigEx {
    private static final boolean DEFAULT_CLOSE_ON_PORT_UNREACHABLE = true;
    private boolean closeOnPortUnreachable = true;

    protected AbstractDatagramSessionConfigEx() {
    }

    @Override
    protected void doSetAll(IoSessionConfigEx config) {
        if (!(config instanceof DatagramSessionConfig)) {
            return;
        }
        if (config instanceof AbstractDatagramSessionConfigEx) {
            AbstractDatagramSessionConfigEx cfg = (AbstractDatagramSessionConfigEx)config;
            if (cfg.isBroadcastChanged()) {
                this.setBroadcast(cfg.isBroadcast());
            }
            if (cfg.isReceiveBufferSizeChanged()) {
                this.setReceiveBufferSize(cfg.getReceiveBufferSize());
            }
            if (cfg.isReuseAddressChanged()) {
                this.setReuseAddress(cfg.isReuseAddress());
            }
            if (cfg.isSendBufferSizeChanged()) {
                this.setSendBufferSize(cfg.getSendBufferSize());
            }
            if (cfg.isTrafficClassChanged() && this.getTrafficClass() != cfg.getTrafficClass()) {
                this.setTrafficClass(cfg.getTrafficClass());
            }
        } else {
            DatagramSessionConfig cfg = (DatagramSessionConfig)((Object)config);
            this.setBroadcast(cfg.isBroadcast());
            this.setReceiveBufferSize(cfg.getReceiveBufferSize());
            this.setReuseAddress(cfg.isReuseAddress());
            this.setSendBufferSize(cfg.getSendBufferSize());
            if (this.getTrafficClass() != cfg.getTrafficClass()) {
                this.setTrafficClass(cfg.getTrafficClass());
            }
        }
    }

    protected boolean isBroadcastChanged() {
        return true;
    }

    protected boolean isReceiveBufferSizeChanged() {
        return true;
    }

    protected boolean isReuseAddressChanged() {
        return true;
    }

    protected boolean isSendBufferSizeChanged() {
        return true;
    }

    protected boolean isTrafficClassChanged() {
        return true;
    }

    @Override
    public boolean isCloseOnPortUnreachable() {
        return this.closeOnPortUnreachable;
    }

    @Override
    public void setCloseOnPortUnreachable(boolean closeOnPortUnreachable) {
        this.closeOnPortUnreachable = closeOnPortUnreachable;
    }
}

