/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.ognl;

import java.beans.PropertyEditor;
import java.lang.reflect.Member;
import java.util.Map;
import ognl.OgnlContext;
import ognl.TypeConverter;
import org.apache.mina.integration.beans.PropertyEditorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTypeConverter
implements TypeConverter {
    @Override
    public Object convertValue(Map ctx, Object target, Member member, String attrName, Object value, Class toType) {
        if (value == null) {
            return null;
        }
        if (attrName == null) {
            OgnlContext ognlCtx = (OgnlContext)ctx;
            attrName = ognlCtx.getCurrentNode().toString().replaceAll("[\" ']+", "");
        }
        if (toType.isAssignableFrom(value.getClass())) {
            return value;
        }
        PropertyEditor e1 = this.getPropertyEditor(target.getClass(), attrName, value.getClass());
        if (e1 == null) {
            throw new IllegalArgumentException("Can't convert " + value.getClass().getSimpleName() + " to " + String.class.getSimpleName());
        }
        e1.setValue(value);
        PropertyEditor e2 = this.getPropertyEditor(target.getClass(), attrName, toType);
        if (e2 == null) {
            throw new IllegalArgumentException("Can't convert " + String.class.getSimpleName() + " to " + toType.getSimpleName());
        }
        e2.setAsText(e1.getAsText());
        return e2.getValue();
    }

    protected PropertyEditor getPropertyEditor(Class<?> type, String attrName, Class<?> attrType) {
        return PropertyEditorFactory.getInstance(attrType);
    }
}

