/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.ognl;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.TypeConverter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.integration.ognl.AbstractPropertyAccessor;
import org.apache.mina.integration.ognl.PropertyTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoSessionFinder {
    private final String query;
    private final TypeConverter typeConverter = new PropertyTypeConverter();
    private final Object expression;

    public IoSessionFinder(String query) {
        if (query == null) {
            throw new NullPointerException("query");
        }
        if ((query = query.trim()).length() == 0) {
            throw new IllegalArgumentException("query is empty.");
        }
        this.query = query;
        try {
            this.expression = Ognl.parseExpression(query);
        }
        catch (OgnlException e) {
            throw new IllegalArgumentException("query: " + query);
        }
    }

    public Set<IoSession> find(Iterable<IoSession> sessions) throws OgnlException {
        if (sessions == null) {
            throw new NullPointerException("sessions");
        }
        LinkedHashSet<IoSession> answer = new LinkedHashSet<IoSession>();
        for (IoSession s : sessions) {
            OgnlContext context = (OgnlContext)Ognl.createDefaultContext(s);
            context.setTypeConverter(this.typeConverter);
            context.put(AbstractPropertyAccessor.READ_ONLY_MODE, (Object)true);
            context.put(AbstractPropertyAccessor.QUERY, this.query);
            Object result = Ognl.getValue(this.expression, (Map)context, (Object)s);
            if (result instanceof Boolean) {
                if (!((Boolean)result).booleanValue()) continue;
                answer.add(s);
                continue;
            }
            throw new OgnlException("Query didn't return a boolean value: " + this.query);
        }
        return answer;
    }
}

