/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty.channel;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.util.internal.StringUtil;
import org.kaazing.mina.netty.buffer.ByteBufferWrappingChannelBuffer;
import org.kaazing.mina.netty.channel.DefaultChannelFutureEx;

public class DownstreamMessageEventEx
implements MessageEvent {
    private final DefaultChannelFutureEx future = new DefaultChannelFutureEx();
    private final ByteBufferWrappingChannelBuffer channelBuf = new ByteBufferWrappingChannelBuffer();
    private Channel channel;
    private Object message;
    private SocketAddress remoteAddress;

    public boolean isResetable() {
        return this.future.isResetable();
    }

    public void reset(Channel channel, ByteBuffer message, SocketAddress remoteAddress, boolean cancellable) {
        if (!this.future.isResetable()) {
            throw new IllegalStateException("Cannot reset message event before future has completed");
        }
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.channel = channel;
        this.future.reset(channel, cancellable);
        this.message = this.channelBuf.wrap(message);
        this.remoteAddress = remoteAddress != null ? remoteAddress : channel.getRemoteAddress();
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public ChannelFuture getFuture() {
        return this.future;
    }

    @Override
    public Object getMessage() {
        return this.message;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String toString() {
        if (this.getRemoteAddress() == this.getChannel().getRemoteAddress()) {
            return this.getChannel().toString() + " WRITE: " + StringUtil.stripControlCharacters(this.getMessage());
        }
        return this.getChannel().toString() + " WRITE: " + StringUtil.stripControlCharacters(this.getMessage()) + " to " + this.getRemoteAddress();
    }
}

