/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.polling.AbstractPollingIoAcceptor;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.AbstractIoSessionConfig;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.transport.socket.DefaultSocketSessionConfig;
import org.apache.mina.transport.socket.DefaultSocketSessionConfigEx;
import org.apache.mina.transport.socket.SocketAcceptorEx;
import org.apache.mina.transport.socket.SocketSessionConfigEx;
import org.apache.mina.transport.socket.nio.NioProcessorEx;
import org.apache.mina.transport.socket.nio.NioSessionEx;
import org.apache.mina.transport.socket.nio.NioSocketSessionEx;
import org.kaazing.mina.core.future.BindFuture;
import org.kaazing.mina.core.future.DefaultBindFuture;
import org.kaazing.mina.core.future.DefaultUnbindFuture;
import org.kaazing.mina.core.future.UnbindFuture;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;
import org.kaazing.mina.core.write.WriteRequestEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NioSocketAcceptorEx
extends AbstractPollingIoAcceptor<NioSessionEx, ServerSocketChannel>
implements SocketAcceptorEx {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioSocketAcceptorEx.class);
    private final List<ThreadLocal<WriteRequestEx>> sharedWriteRequests = DefaultWriteRequestEx.ShareableWriteRequest.initWithLayers(16);
    private int backlog = 50;
    private boolean reuseAddress;
    private volatile Selector selector;

    public NioSocketAcceptorEx() {
        super((IoSessionConfig)new DefaultSocketSessionConfigEx(), NioProcessorEx.class);
        ((DefaultSocketSessionConfigEx)this.getSessionConfig()).init(this);
    }

    public NioSocketAcceptorEx(int processorCount) {
        super((IoSessionConfig)new DefaultSocketSessionConfigEx(), NioProcessorEx.class, processorCount);
        ((DefaultSocketSessionConfigEx)this.getSessionConfig()).init(this);
    }

    public NioSocketAcceptorEx(IoProcessor<NioSessionEx> processor) {
        super((IoSessionConfig)new DefaultSocketSessionConfigEx(), processor);
        ((DefaultSocketSessionConfig)((Object)this.getSessionConfig())).init(this);
    }

    public NioSocketAcceptorEx(Executor executor, IoProcessor<NioSessionEx> processor) {
        super((IoSessionConfig)new DefaultSocketSessionConfigEx(), executor, processor);
        ((DefaultSocketSessionConfig)((Object)this.getSessionConfig())).init(this);
    }

    @Override
    public ThreadLocal<WriteRequestEx> getThreadLocalWriteRequest(int ioLayer) {
        return this.sharedWriteRequests.get(ioLayer);
    }

    @Override
    protected void init() throws Exception {
        this.selector = Selector.open();
    }

    @Override
    protected void destroy() throws Exception {
        if (this.selector != null) {
            this.selector.close();
        }
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return NioSocketSessionEx.METADATA;
    }

    @Override
    public SocketSessionConfigEx getSessionConfig() {
        return (SocketSessionConfigEx)super.getSessionConfig();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)super.getLocalAddress();
    }

    @Override
    public InetSocketAddress getDefaultLocalAddress() {
        return (InetSocketAddress)super.getDefaultLocalAddress();
    }

    @Override
    public void setDefaultLocalAddress(InetSocketAddress localAddress) {
        this.setDefaultLocalAddress((SocketAddress)localAddress);
    }

    @Override
    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReuseAddress(boolean reuseAddress) {
        Object object = this.bindLock;
        synchronized (object) {
            if (this.isActive()) {
                throw new IllegalStateException("reuseAddress can't be set while the acceptor is bound.");
            }
            this.reuseAddress = reuseAddress;
        }
    }

    @Override
    public int getBacklog() {
        return this.backlog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBacklog(int backlog) {
        Object object = this.bindLock;
        synchronized (object) {
            if (this.isActive()) {
                throw new IllegalStateException("backlog can't be set while the acceptor is bound.");
            }
            this.backlog = backlog;
        }
    }

    @Override
    public BindFuture bindAsync(SocketAddress localAddress) {
        try {
            this.bind(localAddress);
            return DefaultBindFuture.succeededFuture();
        }
        catch (IOException e) {
            DefaultBindFuture future = new DefaultBindFuture();
            future.setException(e);
            return future;
        }
    }

    @Override
    public UnbindFuture unbindAsync(SocketAddress localAddress) {
        try {
            this.unbind(localAddress);
            return DefaultUnbindFuture.succeededFuture();
        }
        catch (Exception e) {
            DefaultUnbindFuture future = new DefaultUnbindFuture();
            future.setException(e);
            return future;
        }
    }

    @Override
    protected NioSessionEx accept(IoProcessor<NioSessionEx> processor, ServerSocketChannel handle) throws Exception {
        SelectionKey key = handle.keyFor(this.selector);
        if (key == null || !key.isValid() || !key.isAcceptable()) {
            return null;
        }
        SocketChannel ch = handle.accept();
        if (ch == null) {
            return null;
        }
        NioSocketSessionEx session = new NioSocketSessionEx(this, processor, ch);
        try {
            session.initSessionConfig();
            return session;
        }
        catch (RuntimeIoException e) {
            if (AbstractIoSessionConfig.REPORT_SESSION_CONFIG_FAILURE) {
                throw e;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unexpected exception initializing session TCP options. Rejecting connection.", (Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ServerSocketChannel open(SocketAddress localAddress) throws Exception {
        ServerSocketChannel channel = ServerSocketChannel.open();
        boolean success = false;
        try {
            channel.configureBlocking(false);
            ServerSocket socket = channel.socket();
            socket.setReuseAddress(this.isReuseAddress());
            if (AbstractIoSessionConfig.ENABLE_BUFFER_SIZE) {
                System.out.println("NioSocketAcceptor.open(): setReceiveBufferSize:" + this.getSessionConfig().getReceiveBufferSize());
                socket.setReceiveBufferSize(this.getSessionConfig().getReceiveBufferSize());
            }
            socket.bind(localAddress, this.getBacklog());
            channel.register(this.selector, 16);
            success = true;
        }
        finally {
            if (!success) {
                this.close(channel);
            }
        }
        return channel;
    }

    @Override
    protected SocketAddress localAddress(ServerSocketChannel handle) throws Exception {
        return handle.socket().getLocalSocketAddress();
    }

    @Override
    protected int select() throws Exception {
        return this.selector.select();
    }

    @Override
    protected Iterator<ServerSocketChannel> selectedHandles() {
        return new ServerSocketChannelIterator(this.selector.selectedKeys());
    }

    @Override
    protected void close(ServerSocketChannel handle) throws Exception {
        SelectionKey key = handle.keyFor(this.selector);
        if (key != null) {
            key.cancel();
        }
        handle.close();
    }

    @Override
    protected void wakeup() {
        this.selector.wakeup();
    }

    private static final class ServerSocketChannelIterator
    implements Iterator<ServerSocketChannel> {
        private final Iterator<SelectionKey> iterator;

        private ServerSocketChannelIterator(Collection<SelectionKey> selectedKeys) {
            this.iterator = selectedKeys.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ServerSocketChannel next() {
            SelectionKey key = this.iterator.next();
            if (key.isValid() && key.isAcceptable()) {
                return (ServerSocketChannel)key.channel();
            }
            return null;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

