/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.mina.core.polling.AbstractPollingIoConnector;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.transport.socket.DatagramConnectorEx;
import org.apache.mina.transport.socket.DatagramSessionConfigEx;
import org.apache.mina.transport.socket.DefaultDatagramSessionConfigEx;
import org.apache.mina.transport.socket.nio.NioDatagramSession;
import org.apache.mina.transport.socket.nio.NioDatagramSessionEx;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;
import org.kaazing.mina.core.write.WriteRequestEx;

public final class NioDatagramConnectorEx
extends AbstractPollingIoConnector<NioSession, DatagramChannel>
implements DatagramConnectorEx {
    private final List<ThreadLocal<WriteRequestEx>> sharedWriteRequests = DefaultWriteRequestEx.ShareableWriteRequest.initWithLayers(16);

    public NioDatagramConnectorEx() {
        super((IoSessionConfig)new DefaultDatagramSessionConfigEx(), NioProcessor.class);
    }

    public NioDatagramConnectorEx(int processorCount) {
        super((IoSessionConfig)new DefaultDatagramSessionConfigEx(), NioProcessor.class, processorCount);
    }

    public NioDatagramConnectorEx(IoProcessor<NioSession> processor) {
        super((IoSessionConfig)new DefaultDatagramSessionConfigEx(), processor);
    }

    public NioDatagramConnectorEx(Class<? extends IoProcessor<NioSession>> processorClass, int processorCount) {
        super((IoSessionConfig)new DefaultDatagramSessionConfigEx(), processorClass, processorCount);
    }

    public NioDatagramConnectorEx(Class<? extends IoProcessor<NioSession>> processorClass) {
        super((IoSessionConfig)new DefaultDatagramSessionConfigEx(), processorClass);
    }

    @Override
    public ThreadLocal<WriteRequestEx> getThreadLocalWriteRequest(int ioLayer) {
        return this.sharedWriteRequests.get(ioLayer);
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return NioDatagramSession.METADATA;
    }

    @Override
    public DatagramSessionConfigEx getSessionConfig() {
        return (DatagramSessionConfigEx)super.getSessionConfig();
    }

    @Override
    public InetSocketAddress getDefaultRemoteAddress() {
        return (InetSocketAddress)super.getDefaultRemoteAddress();
    }

    @Override
    public void setDefaultRemoteAddress(InetSocketAddress defaultRemoteAddress) {
        super.setDefaultRemoteAddress(defaultRemoteAddress);
    }

    @Override
    protected void init() throws Exception {
    }

    @Override
    protected DatagramChannel newHandle(SocketAddress localAddress) throws Exception {
        DatagramChannel ch = DatagramChannel.open();
        try {
            if (localAddress != null) {
                ch.socket().bind(localAddress);
            }
            return ch;
        }
        catch (Exception e) {
            ch.close();
            throw e;
        }
    }

    @Override
    protected boolean connect(DatagramChannel handle, SocketAddress remoteAddress) throws Exception {
        handle.connect(remoteAddress);
        return true;
    }

    @Override
    protected NioSession newSession(IoProcessor<NioSession> processor, DatagramChannel handle) {
        NioDatagramSessionEx session = new NioDatagramSessionEx(this, handle, processor);
        session.getConfig().setAll(this.getSessionConfig());
        return session;
    }

    @Override
    protected void close(DatagramChannel handle) throws Exception {
        handle.disconnect();
        handle.close();
    }

    @Override
    protected Iterator<DatagramChannel> allHandles() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    protected AbstractPollingIoConnector.ConnectionRequest getConnectionRequest(DatagramChannel handle) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void destroy() throws Exception {
    }

    @Override
    protected boolean finishConnect(DatagramChannel handle) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void register(DatagramChannel handle, AbstractPollingIoConnector.ConnectionRequest request) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int select(int timeout) throws Exception {
        return 0;
    }

    @Override
    protected Iterator<DatagramChannel> selectedHandles() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    protected void wakeup() {
    }
}

