/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty;

import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.session.IoSessionInitializer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.netty.ChannelIoSession;
import org.kaazing.mina.netty.IoSessionIdleTracker;

public class IoSessionChannelHandler
extends SimpleChannelHandler {
    private final ChannelIoSession<? extends ChannelConfig> session;
    private final IoBufferAllocatorEx<?> allocator;
    private final IoFuture future;
    private final IoSessionInitializer<?> initializer;
    private final IoSessionIdleTracker idleTracker;

    public IoSessionChannelHandler(ChannelIoSession<? extends ChannelConfig> session, IoFuture future, IoSessionInitializer<?> initializer, IoSessionIdleTracker idleTracker) {
        this.session = session;
        this.allocator = session.getBufferAllocator();
        this.future = future;
        this.initializer = initializer;
        this.idleTracker = idleTracker;
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.session.getService().initializeSession(this.session, this.future, this.initializer);
        this.idleTracker.addSession(this.session);
        this.session.getProcessor().add(this.session);
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.session.getProcessor().remove(this.session);
        this.idleTracker.removeSession(this.session);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        IoFilterChain filterChain = this.session.getFilterChain();
        filterChain.fireExceptionCaught(e.getCause());
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object message = e.getMessage();
        if (message instanceof ChannelBuffer) {
            ChannelBuffer buf = (ChannelBuffer)message;
            message = this.allocator.wrap(buf.toByteBuffer());
            buf.skipBytes(buf.readableBytes());
        }
        IoFilterChain filterChain = this.session.getFilterChain();
        filterChain.fireMessageReceived(message);
    }

    @Override
    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        int writtenBytes = (int)e.getWrittenAmount();
        this.session.increaseWrittenBytes(writtenBytes, System.currentTimeMillis());
    }
}

