/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.netty;

import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.kaazing.mina.netty.ChannelIoAcceptor;
import org.kaazing.mina.netty.IoSessionFactoryChannelHandler;

public class IoAcceptorChannelHandler
extends SimpleChannelUpstreamHandler {
    private final ChannelIoAcceptor<?, ?, ?> acceptor;
    private final ChannelGroup channelGroup;
    private final ChannelHandler bindHandler;
    private ChannelPipelineFactory pipelineFactory;

    public IoAcceptorChannelHandler(ChannelIoAcceptor<?, ?, ?> acceptor, ChannelGroup channelGroup, ChannelHandler bindHandler) {
        this.acceptor = acceptor;
        this.channelGroup = channelGroup;
        this.bindHandler = bindHandler;
    }

    public void setPipelineFactory(ChannelPipelineFactory pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }

    @Override
    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        String baseName = ctx.getName();
        String name = String.format("%s:bind", baseName);
        ctx.getPipeline().addAfter(baseName, name, this.bindHandler);
        super.channelOpen(ctx, e);
    }

    @Override
    public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
        Channel childChannel = e.getChildChannel();
        if (this.channelGroup != null) {
            this.channelGroup.add(childChannel);
        }
        ChannelPipeline childPipeline = childChannel.getPipeline();
        if (this.pipelineFactory != null) {
            ChannelPipeline newChildPipeline = this.pipelineFactory.getPipeline();
            for (Map.Entry<String, ChannelHandler> entry : newChildPipeline.toMap().entrySet()) {
                String key = entry.getKey();
                ChannelHandler handler = entry.getValue();
                childPipeline.addLast(key, handler);
            }
        }
        childPipeline.addLast("factory", new IoSessionFactoryChannelHandler(this.acceptor, null, this.acceptor.getIoSessionInitializer()));
        super.childChannelOpen(ctx, e);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        ctx.sendUpstream(e);
    }
}

